%% USGS Spectral Library 2025
% Martin H. Trauth, 16 October 2025
%
% Data source:
% Kokaly, R., et al. (2017) USGS Spectral Library Version 7 Data. USGS Asset
% Identifier Service (AIS).
% https://www.usgs.gov/data/usgs-spectral-library-version-7-data

%%
clear, close all, clc

%%
% Load wavelengths
cd wavelengths
filelist_wv = dir(fullfile('*.txt'));
filename_wv = {filelist_wv.name};
for i = 1 : 1
    fidA = fopen(filename_wv{i});
    A1 = textscan(fidA,'%f',...
       'Headerlines',1,...
       'CollectOutput',1);
    fclose(fidA);
    wv(:,i) = A1{1};
end
cd ..

%% 
% Load spectral data
cd spectraldata
filelist_spec = dir(fullfile('*.txt'));
filename_spec = {filelist_spec.name};
for i = 1 : length(filelist_spec)

    fidB = fopen(filename_spec{i});
    B1 = textscan(fidB,'%f',...
       'Headerlines',1,...
       'CollectOutput',1);
    fclose(fidB);
    spec(:,i) = B1{1};
end
cd ..

%%
% Create legend text
for i = 1 : length(filelist_spec)
    legtex(i,:) = filename_spec{i}(10:16);
end

%%
figure(...
    'Position',[200 200 800 600],...
    'Color',[1 1 1]);
axes(...
    'XLim',[0.25 2.65],...
    'Box','on',...
    'XGrid','On',...
    'YGrid','On',...
    'Units','Centimeters',...
    'Position',[2 2 10 6],...
    'LineWidth',0.6,...
    'FontName','Helvetica',...
    'FontSize',8);
for i = 1 : length(filelist_spec)
    line(wv,spec(:,i),...
        'LineWidth',0.75)
end
xlabel('Wavelength (microns)',...
    'FontSize',8)
ylabel('Spectral Reflectance',...
    'FontSize',8)
legend(legtex,'Location','Southwest',...
    'FontSize',8)
legend('boxoff')

%%
print -dpng -r300 usgs_spectrallibrary_2025.png

%%
save usgs_spectrallibrary_2025.mat