#%%
import numpy as np
import numpy.ma as ma
import pandas as pd
import matplotlib.pyplot as plt

#%%
alp = 0.5

#%%
x = np.array([[0,0,1],
              [1,1,1],
              [1,0,1],
              [0,1,1]])

#%%
y = np.array([[0,1,1,0]])
y = np.transpose(y)

#%%
np.random.seed(0)
w = np.random.rand(3,1)
w = w/np.sum(w)

#%%
def sigfct(x = None):
    y = 1./(1+np.exp(-x));
    return y

#%%
def sigfctderiv(x = None):
    y = sigfct(x)*(1-sigfct(x));
    return y

#%%
Ei = np.zeros((1,100))
oji = np.zeros((4,100))
wi = np.zeros((3,100))

for i in range(100):
    netj = np.matmul(x,w)
    oj = sigfct(netj)   
    w = w + alp*np.matmul(np.transpose(x),\
        (sigfctderiv(netj)*(y-oj)))
    Ei[:,i] = np.mean((y-oj)**2)
    oji[:,i] = np.transpose(oj)
    wi[:,i] = np.transpose(w)
    
#%%
d1 = ma.concatenate([np.transpose(x),w],axis=1)
d1 = np.transpose(d1)
t1 = pd.DataFrame({
    '1':d1[:,0],
    '2':d1[:,1],
    '3':d1[:,2]},
    index=['1','2','3','4','Weights'])
print(t1)

#%%
d2 = ma.concatenate([y,oj],axis=1)
t2 = pd.DataFrame({
    'y':d2[:,0],
    'oj':d2[:,1]},
    index=[' ',' ',' ',' '])
print(t2)
    
#%%
s = np.array([[0,0,1]])
print(sigfct(np.matmul(s,w)))
    
#%%
plt.figure(
    facecolor=(1,1,1))
plt.axes(
    xlabel='Iterations',
    ylabel='Weights')
plt.plot(np.linspace(1,100,100),wi[0,:],
    linewidth=1)
plt.plot(np.linspace(1,100,100),wi[1,:],
    linewidth=1)
plt.plot(np.linspace(1,100,100),wi[2,:],
    linewidth=1)
plt.legend(['Weight 1',
    'Weight 2',
    'Weight 3'])
plt.grid()
plt.savefig('figure_2_9_1.png',dpi=300)
plt.show()

#%%
plt.figure(
    facecolor=(1,1,1))
plt.axes(
    xlabel='Iterations',
    ylabel='Weights')
plt.plot(np.linspace(1,100,100),Ei[0,:],
    linewidth=1)
plt.legend(['Mean Square Error'])
plt.grid()
plt.savefig('figure_2_9_2.png',dpi=300)
plt.show()

#%%
plt.figure(
    facecolor=(1,1,1))
plt.axes(
    xlabel='Iterations',
    ylabel='Weights')
plt.plot(np.linspace(1,100,100),oji[0,:],
    linewidth=1)
plt.plot(np.linspace(1,100,100),oji[1,:],
    linewidth=1)
plt.plot(np.linspace(1,100,100),oji[2,:],
    linewidth=1)
plt.plot(np.linspace(1,100,100),oji[3,:],
    linewidth=1)
plt.legend(['Value 1',
    'Value 2',
    'Value 3',
    'Value 4'])
plt.grid()
plt.savefig('figure_2_9_3.png',dpi=300)
plt.show()

#%%
xx = np.linspace(-10,10,201)
yy = sigfct(xx)

plt.figure(
    facecolor=(1,1,1))
plt.axes(
    xlabel='netj',
    ylabel='oj = sigfct(netj)')
plt.plot(xx,yy,
    linewidth=1)
plt.grid()
plt.savefig('figure_2_9_4.png',dpi=300)
plt.show()

#%%
xx = np.linspace(-10,10,201)
yy = sigfctderiv(xx)

plt.figure(
    facecolor=(1,1,1))
plt.axes(
    xlabel='netj',
    ylabel='sigfctderiv(netj)')
plt.plot(xx,yy,
    linewidth=1)
plt.grid()
plt.savefig('figure_2_9_5.png',dpi=300)
plt.show()
