%%
clear, close all, clc

%%
alp = 0.5;

%%
x = [0 0 1
     1 1 1
     1 0 1
     0 1 1];

%%
y = [0
     1
     1
     0];

%%
rng(0)
w = rand(3,1);
w = w/sum(w);

%%
for i = 1 : 100
    netj = x*w;
    oj = sigfct(netj);
    w = w + alp*x'*(sigfctderiv(netj).*(y-oj)); 
    Ei(:,i) = mean((y-oj).^2);
    oji(:,i) = oj;
    wi(:,i) = w;
end

%%
table(cat(1,x,w'),...
   'VariableNames',["Input"],...
   'RowNames',["1","2","3","4","Weights"])

%%
table(y,oj,...
   'VariableNames',["Output","Prediction"])

%%
s = [0 0 1];
sigfct(s*w)

%%
axes('LineWidth',0.7,...
   'FontSize',12,...
   'XGrid','On',...
   'YGrid','On')
line(1:length(wi),wi,...
   'LineWidth',1)
xlabel('Iteration')
ylabel('Weights')
legend('Weight 1','Weight 2','Weight 3',...
   'FontSize',12,...
   'Location','East',...
   'Box','Off')

print -dpng -r300 figure_2_9_1.png

%%
figure
axes('LineWidth',0.7,...
   'FontSize',12,...
   'XGrid','On',...
   'YGrid','On')
line(1:length(Ei),Ei,...
   'LineWidth',1)
xlabel('Iteration')
ylabel('Error')
legend('Mean Squared Error',...
   'FontSize',12,...
   'Location','East',...
   'Box','Off')

print -dpng -r300 figure_2_9_2.png

%%
figure
axes('LineWidth',0.7,...
   'FontSize',12,...
   'XGrid','On',...
   'YGrid','On')
line(1:length(oji),oji,...
   'LineWidth',1)
xlabel('Iteration')
ylabel('Predicted Values')
legend('Value 1','Value 2','Value 3','Value 4',...
   'FontSize',12,...
   'Location','East',...
   'Box','Off')

print -dpng -r300 figure_2_9_3.png

%%
function y = sigfct(x)
   y = 1./(1+exp(-x));
end

%%
xx = -10 : 0.1 : 10;
yy = sigfct(xx);

figure
axes('LineWidth',0.7,...
   'FontSize',12,...
   'XGrid','On',...
   'YGrid','On')
line(xx,yy,...
   'LineWidth',1)
xlabel('netj')
ylabel('oj = sigfct(netj)')

print -dpng -r300 figure_2_9_4.png

%%
function y = sigfctderiv(x)
    y = sigfct(x).*(1 - sigfct(x));
end

%%
xx = -10 : 0.1 : 10;
yy = sigfctderiv(xx);

figure
axes('LineWidth',0.7,...
   'FontSize',12,...
   'XGrid','On',...
   'YGrid','On')
line(xx,yy,...
   'LineWidth',1)
xlabel('netj')
ylabel('sigfctderiv(netj)')

print -dpng -r300 figure_2_9_5.png
