%% MAPIR Survey 2 and 3 Comparison
%
% by Martin H. Trauth, 12 August 2025
% http://mres.uni-potsdam.de

%%
clear, clc, close all

load mapirsurvey2_660_850.mat
load mapirsurvey2_450.mat
load mapirsurvey3_725.mat
load mapirsurvey3_615_490_808.mat
load mapirsurvey2_rgb.mat
load mapirsurvey2_550.mat

%%
image1 = mapirsurvey2_450;                % 450 nm
image2 = mapirsurvey3_615_490_808(:,:,2); % 490 nm
image3 = mapirsurvey2_550;                % 550 nm
image4 = mapirsurvey3_615_490_808(:,:,1); % 615 nm
image5 = mapirsurvey2_660_850(:,:,1);     % 660 nm
image6 = mapirsurvey3_725;                % 725 nm
image7 = mapirsurvey3_615_490_808(:,:,3); % 808 nm
image8 = mapirsurvey2_660_850(:,:,3);     % 850 nm
image9 = mapirsurvey2_rgb;                % RGB

%%
close all
figure('Position',[50 800 800 800])
tiledlayout(3,3, ...
    'TileSpacing','compact');
nexttile, imshow(image1), title('450 nm Blue')
nexttile, imshow(image2), title('490 nm Cyan')
nexttile, imshow(image3), title('550 nm Green')
nexttile, imshow(image4), title('615 nm Orange')
nexttile, imshow(image5), title('660 nm Red')
nexttile, imshow(image6), title('725 nm RedEdge')
nexttile, imshow(image7), title('808 nm NIR')
nexttile, imshow(image8), title('850 nm NIR')
nexttile, imshow(image9), title('XXX nm RGB')

%%
% Registration
[optimizer,metric] = imregconfig('monomodal');

%%
% optimizer.GrowthFactor         = 1.050000e+00;
% optimizer.Epsilon              = 1.500000e-06;
% optimizer.InitialRadius        = 6.250000e-03;
% optimizer.MaximumIterations    = 100;
% 
% metric.NumberOfSpatialSamples  = 500;
% metric.NumberOfHistogramBins   = 50;
% metric.UseAllPixels            = 1;

%%
% Define reference image
refimage = image3;

%%
image1_reg = imregister(image1,refimage,'affine',optimizer,metric);
figure, tiledlayout(1,3)
nexttile, imshow(image1), colormap(gray), title('450 nm Blue')
nexttile, imshow(refimage), title('450 nm Blue')
nexttile, imshowpair(refimage,image1_reg,'blend'), title('BOTH')

%%
image2_reg = imregister(image2,refimage,'affine',optimizer,metric);
figure, tiledlayout(1,3)
nexttile, imshow(refimage), colormap(gray), title('550 nm Green')
nexttile, imshow(refimage), title('490 nm Cyan')
nexttile, imshowpair(refimage,image2_reg,'blend'), title('BOTH')

%%
image3_reg = imregister(image3,refimage,'affine',optimizer,metric);
figure, tiledlayout(1,3)
nexttile, imshow(image3), colormap(gray), title('550 nm Green')
nexttile, imshow(refimage), title('450 nm Blue')
nexttile, imshowpair(refimage,image3_reg,'blend'), title('BOTH')

%%
image4_reg = imregister(image4,refimage,'affine',optimizer,metric);
figure, tiledlayout(1,3)
nexttile, imshow(image4), colormap(gray), title('615 nm Orange')
nexttile, imshow(refimage), title('450 nm Blue')
nexttile, imshowpair(refimage,image4_reg,'blend'), title('BOTH')

%%
image5_reg = imregister(image5,refimage,'affine',optimizer,metric);
figure, tiledlayout(1,3)
nexttile, imshow(image5), colormap(gray), title('660 nm Red')
nexttile, imshow(refimage), title('450 nm Blue')
nexttile, imshowpair(refimage,image5_reg,'blend'), title('BOTH')

%%
image6_reg = imregister(image6,refimage,'affine',optimizer,metric);
figure, tiledlayout(1,3)
nexttile, imshow(image6), colormap(gray), title('725 nm RedEdge')
nexttile, imshow(refimage), title('450 nm Blue')
nexttile, imshowpair(refimage,image6_reg,'blend'), title('BOTH')

%%
image7_reg = imregister(image7,refimage,'affine',optimizer,metric);
figure, tiledlayout(1,3)
nexttile, imshow(image7), colormap(gray), title('808 nm NIR')
nexttile, imshow(refimage), title('450 nm Blue')
nexttile, imshowpair(refimage,image7_reg,'blend'), title('BOTH')

%%
image8_reg = imregister(image8,refimage,'affine',optimizer,metric);
figure, tiledlayout(1,3)
nexttile, imshow(image8), colormap(gray), title('850 nm NIR')
nexttile, imshow(refimage), title('450 nm Blue')
nexttile, imshowpair(refimage,image8_reg,'blend'), title('BOTH')

%%
image9_reg = imregister(image9(:,:,1),refimage,'affine',optimizer,metric);
figure, tiledlayout(1,3)
nexttile, imshow(image9), colormap(gray), title('XXX nm RGB')
nexttile, imshow(refimage), title('450 nm Blue')
nexttile, imshowpair(refimage,image9_reg,'blend'), title('BOTH')

%%
close all

%%
image = cat(3,...
    image1_reg,...
    image2_reg,...
    image3_reg,...
    image4_reg,...
    image5_reg,...
    image6_reg,...
    image7_reg,...
    image8_reg,...
    image9_reg);
whos

%%
cmap = 'jet';
figure('Position',[50 800 800 800])
tiledlayout(3,3, ...
    'TileSpacing','compact');
nexttile, imshow(image1_reg), title('450 nm Blue')
colormap(cmap)
nexttile, imshow(image2_reg), title('490 nm Cyan')
colormap(cmap)
nexttile, imshow(image3_reg); title('550 nm Green')
colormap(cmap)
nexttile, imshow(image4_reg); title('615 nm Orange')
colormap(cmap)
nexttile, imshow(image5_reg); title('660 nm Red')
colormap(cmap)
nexttile, imshow(image6_reg); title('725 nm RedEdge')
colormap(cmap)
nexttile, imshow(image7_reg); title('808 nm NIR')
colormap(cmap)
nexttile, imshow(image8_reg); title('850 nm NIR')
colormap(cmap)
nexttile, imshow(image9); title('XXX nm RGB')
colormap(cmap)

print -dpng -r300 mapirsurvey3all.png