function [error,fil_out,w1,wk]=lms2(prim,ref,n,mu,limit);
% The following program inplements the fixed mu LMS adaptive algorithm.
% Its inputs are
%       prim    -       primary input.
%       ref     -       reference input.
%       n       -       filter order.
%       mu      -       convergence parameter.
%       limit   -       limiting value for the error before the
%                       algorithm aborts.
% Its outputs are
%       error   -       error output.
%       fil_out -       output of the adaptive filter before
%                       subtraction.
%       w1      -       final filter weights.
%       wk      -       convergence of the first filter weight.
%                                                              
%     Vijay Parsa,                      Work Ph: (506) 453 4966.       
%     Graduate Student,                 Home Ph: (506) 454 1794.       
%     Institute of Biomedical Engg.     Fax: (506) 453 4827.           
%     University of New Brunwick,       Email: z98t@jupiter.csd.unb.ca 
%     Fredericton, NB.                         z98t@unb.ca             
%     Canada E3B 5A3.                                                  
%         
%     modified by M.H. Trauth Aug. 1994                                                      
%
                % Initialization.
prim=prim-mean(prim);
ref=ref-mean(ref);
prim=prim(:);ref=ref(:);
w1=zeros(1,n);
N=length(ref);
                % Main Program.
for i=n:N
  temp=ref(i:-1:i-n+1);
  fil_out(i)=w1*temp;
  error(i)=prim(i-fix(n/2))-fil_out(i);
  if error(i)>limit
        fprintf('\n\nFilter Stability Problems. reduce mu. aborting......\n\n');
        break;
  end;
  w1=w1+2*mu*error(i)*temp';
  wk(i)=w1(1);
	if rem(i,100)==0
		w1
	end
end;
