classdef canctool_exported < matlab.apps.AppBase

    % Properties that correspond to app components
    properties (Access = public)
        figure1                  matlab.ui.Figure
        text11                   matlab.ui.control.Label
        pushbutton1              matlab.ui.control.Button
        text3                    matlab.ui.control.Label
        edit3                    matlab.ui.control.EditField
        text2                    matlab.ui.control.Label
        edit2                    matlab.ui.control.EditField
        text1                    matlab.ui.control.Label
        edit1                    matlab.ui.control.EditField
        Mean_Squared_Error_Axis  matlab.ui.control.UIAxes
        Filtered_Signal_Axis     matlab.ui.control.UIAxes
        Original_Signal_Axis     matlab.ui.control.UIAxes
    end

    
    methods (Access = private)
        % Update components that require runtime configuration
        function addRuntimeConfigurations(app)
            
            % Set component properties that require runtime configuration
            app.figure1.CloseRequestFcn = @(o,~)delete(o);
        end
    end

    % Callbacks that handle component events
    methods (Access = private)

        % Code that executes after component creation
        function canctool_OpeningFcn(app, varargin)
            % --- Executes just before canctool is made visible.
            
            % Add runtime required configuration - Added by Migration Tool
            addRuntimeConfigurations(app);
            
            % Ensure that the app appears on screen when run
            movegui(app.figure1, 'onscreen');
            
            % Create GUIDE-style callback args - Added by Migration Tool
            [hObject, eventdata, handles] = convertToGUIDECallbackArguments(app); %#ok<ASGLU>
            
            % This function has no output args, see OutputFcn.
            % hObject    handle to figure
            % eventdata  reserved - to be defined in a future version of MATLAB
            % handles    structure with handles and user data (see GUIDATA)
            % varargin   command line arguments to canctool (see VARARGIN)
            
            % Choose default command line output for canctool
            handles.output = hObject;
            
            % Update handles structure
            guidata(hObject, handles);
            
            % UIWAIT makes canctool wait for user response (see UIRESUME)
            % uiwait(handles.figure1);
            
            global x s u l iter
            
            % Default values
            u    = 0.00001;
            l    = 11;
            iter = 100;
            
            % Collect s and x from varargin
            s = varargin{1};
            x = varargin{2};
        end

        % Value changed function: edit1
        function edit1_Callback(app, event)
            % Create GUIDE-style callback args - Added by Migration Tool
            [hObject, eventdata, handles] = convertToGUIDECallbackArguments(app, event); %#ok<ASGLU>
            
            % hObject    handle to edit1 (see GCBO)
            % eventdata  reserved - to be defined in a future version of MATLAB
            % handles    structure with handles and user data (see GUIDATA)
            
            % Hints: get(hObject,'String') returns contents of edit1 as text
            %        str2double(get(hObject,'String')) returns contents of edit1 as a double
            global l
            l = str2double(get(hObject,'String'));
        end

        % Value changed function: edit2
        function edit2_Callback(app, event)
            % Create GUIDE-style callback args - Added by Migration Tool
            [hObject, eventdata, handles] = convertToGUIDECallbackArguments(app, event); %#ok<ASGLU>
            
            % hObject    handle to edit2 (see GCBO)
            % eventdata  reserved - to be defined in a future version of MATLAB
            % handles    structure with handles and user data (see GUIDATA)
            
            % Hints: get(hObject,'String') returns contents of edit2 as text
            %        str2double(get(hObject,'String')) returns contents of edit2 as a double
            global u
            u = str2double(get(hObject,'String'));
        end

        % Value changed function: edit3
        function edit3_Callback(app, event)
            % Create GUIDE-style callback args - Added by Migration Tool
            [hObject, eventdata, handles] = convertToGUIDECallbackArguments(app, event); %#ok<ASGLU>
            
            % hObject    handle to edit3 (see GCBO)
            % eventdata  reserved - to be defined in a future version of MATLAB
            % handles    structure with handles and user data (see GUIDATA)
            
            % Hints: get(hObject,'String') returns contents of edit3 as text
            %        str2double(get(hObject,'String')) returns contents of edit3 as a double
            global iter
            iter = str2double(get(hObject,'String'));
        end

        % Button pushed function: pushbutton1
        function pushbutton1_Callback(app, event)
            % --- Executes on button press in pushbutton1.
            
            % Create GUIDE-style callback args - Added by Migration Tool
            [hObject, eventdata, handles] = convertToGUIDECallbackArguments(app, event); %#ok<ASGLU>
            
            % hObject    handle to pushbutton1 (see GCBO)
            % eventdata  reserved - to be defined in a future version of MATLAB
            % handles    structure with handles and user data (see GUIDATA)
            
            global x s u l iter
            
            [n1,n2]=size(s);n=n2;index=0; % Formatting
            if n1>n2
                s=s';x=x';n=n1;index=1;
            end
            
            plot(handles.Original_Signal_Axis,1:length(s),s,1:length(x),x)
            title(handles.Original_Signal_Axis,['Original Signals'])
            XLim = get(handles.Original_Signal_Axis,'XLim');
            YLim = get(handles.Original_Signal_Axis,'YLim');
            
            w(1:l)=zeros(1,l);e(1:n)=zeros(1,n); % Initialization
            xx(1:l)=zeros(1,l);ss(1:l)=zeros(1,l);
            z(1:n)=zeros(1,n);y(1:n)=zeros(1,n);
            ors=s;ms(1:n)=mean(s).*ones(size(1:n));
            s=s-ms;x=x-ms;ors=ors-ms;
            
            clear mer
            
            for it=1:iter % Iterations
                for I=(l+1):(n+1) % Filter loop
            		for k=1:l
                        xx(k)=x(I-k);ss(k)=s(I-k);
                    end
                    for J=1:l
                        y(I-1)=y(I-1)+w(J).*xx(J);
                        z(I-1)=z(I-1)+w(J).*ss(J);
                    end
                        e(I-1)=ors(I-1-(fix(l/2)))-y(I-1);
                    for J=1:l
                        w(J)=w(J)+2.*u.*e(I-1).*xx(J);
                    end
                end % End filter loop
            	for I=1:n % Phase correction
            		if I<=fix(l/2)
            			yy(I)=0;zz(I)=0;ee(I)=0;
            		elseif I>n-fix(l/2)
            			yy(I)=0;zz(I)=0;ee(I)=0;
            		else
            			yy(I)=y(I+fix(l/2));
                        zz(I)=z(I+fix(l/2));
            			ee(I)=abs(e(I+fix(l/2)));
            		end
            			yy(I)=yy(I)+ms(I);
                        zz(I)=zz(I)+ms(I);
                end % End phase correction
            	y(1:n)=zeros(size(1:n));
            	z(1:n)=zeros(size(1:n));
            
                if it < iter
                plot(handles.Filtered_Signal_Axis,1:length(yy),yy)
                title(handles.Filtered_Signal_Axis,['Filter output after iteration ',num2str(it)])
                set(handles.Filtered_Signal_Axis,'XLim',XLim)
                set(handles.Filtered_Signal_Axis,'YLim',YLim)
                else
                plot(handles.Filtered_Signal_Axis,1:length(yy),yy,1:length(ee),ee)
                title(handles.Filtered_Signal_Axis,['Filter output after iteration ',num2str(it)])
                set(handles.Filtered_Signal_Axis,'XLim',XLim)
                set(handles.Filtered_Signal_Axis,'YLim',YLim)
                end
            
                mer(it)=mean(ee((fix(l/2)):(n-fix(l/2))).^2);
                pause(0.2)
            end % End iterations
            if index==1 % Reformatting
                zz=zz';yy=yy';ee=ee'; mer=mer';
            end
            
            plot(handles.Mean_Squared_Error_Axis,mer)
            title(handles.Mean_Squared_Error_Axis,['Learning Curve'])
            
            % Export results to workspace
            assignin('base','yy' ,yy)
            assignin('base','zz' ,zz)
            assignin('base','ee' ,ee)
            assignin('base','mer',mer)
        end
    end

    % Component initialization
    methods (Access = private)

        % Create UIFigure and components
        function createComponents(app)

            % Create figure1 and hide until all components are created
            app.figure1 = uifigure('Visible', 'off');
            colormap(app.figure1, 'parula');
            app.figure1.Position = [728 235 733 689];
            app.figure1.Name = 'canctool';
            app.figure1.Resize = 'off';
            app.figure1.HandleVisibility = 'callback';
            app.figure1.Tag = 'figure1';

            % Create Original_Signal_Axis
            app.Original_Signal_Axis = uiaxes(app.figure1);
            app.Original_Signal_Axis.Box = 'on';
            app.Original_Signal_Axis.FontSize = 10;
            app.Original_Signal_Axis.NextPlot = 'replace';
            app.Original_Signal_Axis.Tag = 'Original_Signal_Axis';
            app.Original_Signal_Axis.Position = [39 358 375 234];

            % Create Filtered_Signal_Axis
            app.Filtered_Signal_Axis = uiaxes(app.figure1);
            app.Filtered_Signal_Axis.Box = 'on';
            app.Filtered_Signal_Axis.FontSize = 10;
            app.Filtered_Signal_Axis.NextPlot = 'replace';
            app.Filtered_Signal_Axis.Tag = 'Filtered_Signal_Axis';
            app.Filtered_Signal_Axis.Position = [39 49 375 234];

            % Create Mean_Squared_Error_Axis
            app.Mean_Squared_Error_Axis = uiaxes(app.figure1);
            app.Mean_Squared_Error_Axis.Box = 'on';
            app.Mean_Squared_Error_Axis.FontSize = 10;
            app.Mean_Squared_Error_Axis.NextPlot = 'replace';
            app.Mean_Squared_Error_Axis.Tag = 'Mean_Squared_Error_Axis';
            app.Mean_Squared_Error_Axis.Position = [435 49 235 234];

            % Create edit1
            app.edit1 = uieditfield(app.figure1, 'text');
            app.edit1.ValueChangedFcn = createCallbackFcn(app, @edit1_Callback, true);
            app.edit1.Tag = 'edit1';
            app.edit1.HorizontalAlignment = 'center';
            app.edit1.FontSize = 10;
            app.edit1.Position = [453.666666666667 518.499999999999 82.8333333333333 35];
            app.edit1.Value = '11';

            % Create text1
            app.text1 = uilabel(app.figure1);
            app.text1.Tag = 'text1';
            app.text1.HorizontalAlignment = 'center';
            app.text1.VerticalAlignment = 'top';
            app.text1.WordWrap = 'on';
            app.text1.FontSize = 10;
            app.text1.Position = [453.666666666667 554.749999999998 82.8333333333333 18.75];
            app.text1.Text = 'Filter Length';

            % Create edit2
            app.edit2 = uieditfield(app.figure1, 'text');
            app.edit2.ValueChangedFcn = createCallbackFcn(app, @edit2_Callback, true);
            app.edit2.Tag = 'edit2';
            app.edit2.HorizontalAlignment = 'center';
            app.edit2.FontSize = 10;
            app.edit2.Position = [453.666666666667 456 82.8333333333333 35];
            app.edit2.Value = '0.00001';

            % Create text2
            app.text2 = uilabel(app.figure1);
            app.text2.Tag = 'text2';
            app.text2.HorizontalAlignment = 'center';
            app.text2.VerticalAlignment = 'top';
            app.text2.WordWrap = 'on';
            app.text2.FontSize = 10;
            app.text2.Position = [453.666666666667 492.249999999999 82.8333333333333 18.75];
            app.text2.Text = 'Convergence';

            % Create edit3
            app.edit3 = uieditfield(app.figure1, 'text');
            app.edit3.ValueChangedFcn = createCallbackFcn(app, @edit3_Callback, true);
            app.edit3.Tag = 'edit3';
            app.edit3.HorizontalAlignment = 'center';
            app.edit3.FontSize = 10;
            app.edit3.Position = [453.666666666667 393.5 82.8333333333333 35];
            app.edit3.Value = '100';

            % Create text3
            app.text3 = uilabel(app.figure1);
            app.text3.Tag = 'text3';
            app.text3.HorizontalAlignment = 'center';
            app.text3.VerticalAlignment = 'top';
            app.text3.WordWrap = 'on';
            app.text3.FontSize = 10;
            app.text3.Position = [453.666666666667 429.75 82.8333333333333 18.75];
            app.text3.Text = 'Iterations';

            % Create pushbutton1
            app.pushbutton1 = uibutton(app.figure1, 'push');
            app.pushbutton1.ButtonPushedFcn = createCallbackFcn(app, @pushbutton1_Callback, true);
            app.pushbutton1.Tag = 'pushbutton1';
            app.pushbutton1.FontSize = 10;
            app.pushbutton1.Position = [583.166666666667 393.5 82.8333333333333 35];
            app.pushbutton1.Text = 'Start';

            % Create text11
            app.text11 = uilabel(app.figure1);
            app.text11.Tag = 'text11';
            app.text11.HorizontalAlignment = 'center';
            app.text11.VerticalAlignment = 'top';
            app.text11.WordWrap = 'on';
            app.text11.FontSize = 18;
            app.text11.Position = [59.3333333333333 626 621.833333333333 33.75];
            app.text11.Text = 'Correlated Adaptive Noise Cancelling';

            % Show the figure after all components are created
            app.figure1.Visible = 'on';
        end
    end

    % App creation and deletion
    methods (Access = public)

        % Construct app
        function app = canctool_exported(varargin)

            runningApp = getRunningApp(app);

            % Check for running singleton app
            if isempty(runningApp)

                % Create UIFigure and components
                createComponents(app)

                % Register the app with App Designer
                registerApp(app, app.figure1)

                % Execute the startup function
                runStartupFcn(app, @(app)canctool_OpeningFcn(app, varargin{:}))
            else

                % Focus the running singleton app
                figure(runningApp.figure1)

                app = runningApp;
            end

            if nargout == 0
                clear app
            end
        end

        % Code that executes before app deletion
        function delete(app)

            % Delete UIFigure when app is deleted
            delete(app.figure1)
        end
    end
end