#!/usr/bin/env pybricks-micropython
from pybricks.hubs import EV3Brick
from pybricks.ev3devices import (Motor, TouchSensor, ColorSensor,
                                 InfraredSensor, UltrasonicSensor, GyroSensor)
from pybricks.parameters import Port, Stop, Direction, Button, Color
from pybricks.tools import wait, StopWatch, DataLog
from pybricks.robotics import DriveBase
from pybricks.media.ev3dev import SoundFile, ImageFile

# Initialize the EV3 Brick.
ev3 = EV3Brick()

# Initialize two motors with default settings on Port A and Port D.
# These will be the left and right motors of the drive base.
mymotor_A = Motor(Port.A)
mymotor_D = Motor(Port.D)
mysonicsensor = UltrasonicSensor(Port.S1)

# The DriveBase is composed of two motors, with a wheel on each motor.
# The wheel_diameter and axle_track values are used to make the motors
# move at the correct speed when you give a motor command. The axle
# track is the distance between the points where the wheels touch the
# ground.
robot = DriveBase(mymotor_A,
                  mymotor_D,
                  wheel_diameter=70,
                  axle_track=150)

#
while mysonicsensor.distance() > 300:
      robot.drive(-200,0)

robot.stop()
robot.straight(-200)