%% Script S4: Script to display the analyzing results
% 
% Trauth, M.H., Asrat, A., Fischer, M., Foerster, V., Kaboth-Bahr, S.,
% Lamb, H.F., Marwan, N., Roberts, H.M., Schaebitz, F., 2024, Combining
% orbital tuning and direct dating approaches to age-depth model
% development for Chew Bahir, Ethiopia. Quaternary Science Advances
% 
% Martin H Trauth 7 June 2024

% Display tuning and spectral analysis results.

    figure('Color',[1 1 1],...
         'Position',[50 500 1600 800])

    % Age Model RRMarch2021.

    % Axes PC2 of color reflectance values.
    axes('Position',[0.05 0.75 0.655 0.2],...
         'Box','On',...
         'FontSize',12,...
         'LineWidth',1,...
         'XLim',[0 700]), hold on
    % PC2 of color reflectance values.
    line(dataage1(:,1),dataage1(:,2),...
         'LineWidth',1);
    % Argon ages.
    errorbar(deinoi_tune1(:,1),[40 30 40 30 40 30],...
        deinoi_tune1(:,3),'Horizontal',...
        'LineStyle','None',...
        'LineWidth',1,...
        'Color',[0 0 0],...
        'Marker','+')
    for i = 1 : 6
    errorstr(i,:) = [num2str(deinoi_tune1(i,2),...
        '%06.2f\n'),' +/- ',...
        num2str(deinoi_tune1(i,3),'%05.2f\n')];
    end
    text(deinoi_tune1(:,1),[40 30 40 30 40 30]+5,errorstr,...
        'HorizontalAlignment','Center',...
        'FontSize',12)
    % Text labels.
    text(10,50,...
         'RRMarch2021',...
         'FontSize',12,...
         'HorizontalAlignment','Left')
    xlabel('Age (kyr BP)')
    ylabel('PC2 Color')
    % Axes Laskar 04 orbital forcing.
    axes('Position',[0.05 0.75 0.655 0.2],...
         'FontSize',12,...
         'LineWidth',1,...
         'YColor',[0.8 0.5 0.3],...
         'Color','None',...
         'YAxisLocation','Right',...
         'XLim',[0 700],...
         'YLim',[0.38 0.46]), hold on
    % Laskar 04 precession.
    line(orbital(:,1),orbital(:,4),...
         'LineWidth',1,...
         'Color',[0.8 0.5 0.3]);
    ylabel('Precession')
    % Axes LS spectrum.
    axes('Position',[0.825 0.75 0.15 0.2],...    
         'Box','On',...
         'FontSize',12,...
         'LineWidth',1,...
         'XLim',[0 0.1],...
         'YLim',[0 2500])
    line(f1,px1,...
        'LineWidth',1)
    line([0.0094 0.0094],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0244 0.0244],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0435 0.0435],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    xlabel('Frequency (1/kyr)')
    ylabel('Power')

    % Age Model MUBAWA.

    % Axes PC2 of color reflectance values.
    axes('Position',[0.05 0.45 0.655 0.2],...
         'Box','On',...
         'FontSize',12,...
         'LineWidth',1,...
         'XLim',[0 700]), hold on
    % PC2 of color reflectance values.
    line(dataage2(:,1),dataage2(:,2),...
         'LineWidth',1);
    % Argon ages.
    errorbar(deinoi_tune2(:,1),[40 30 40 30 40 30],...
        deinoi_tune2(:,3),'Horizontal',...
        'LineStyle','None',...
        'LineWidth',1,...
        'Color',[0 0 0],...
        'Marker','+')
    for i = 1 : 6
    errorstr(i,:) = [num2str(deinoi_tune2(i,2),...
        '%06.2f\n'),' +/- ',...
        num2str(deinoi_tune2(i,3),'%05.2f\n')];
    end
    text(deinoi_tune2(:,1),[40 30 40 30 40 30]+5,errorstr,...
        'HorizontalAlignment','Center',...
        'FontSize',12)
    % Text labels.
    text(10,50,...
         'MUBAWA',...
         'FontSize',12,...
         'HorizontalAlignment','Left')
    xlabel('Age (kyr BP)')
    ylabel('PC2 Color')
    % Axes Laskar 04 orbital forcing.
    axes('Position',[0.05 0.45 0.655 0.2],...
         'FontSize',12,...
         'LineWidth',1,...
         'YColor',[0.8 0.5 0.3],...
         'Color','None',...
         'YAxisLocation','Right',...
         'XLim',[0 700],...
         'YLim',[0.38 0.46]), hold on
    % Laskar 04 precession.
    line(orbital(:,1),orbital(:,4),...
         'LineWidth',1,...
         'Color',[0.8 0.5 0.3]);
    ylabel('Precession')
    % Axes LS spectrum.
    axes('Position',[0.825 0.45 0.15 0.2],...    
         'Box','On',...
         'FontSize',12,...
         'LineWidth',1,...
         'XLim',[0 0.1],...
         'YLim',[0 2500])
    line(f2,px2,...
        'LineWidth',1)
    line([0.0094 0.0094],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0244 0.0244],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0435 0.0435],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    xlabel('Frequency (1/kyr)')
    ylabel('Power')

    % Age Model RRMarch2021+MHTXXX.

    % Axes PC2 of color reflectance values.
    axes('Position',[0.05 0.15 0.655 0.2],...
         'Box','On',...
         'FontSize',12,...
         'LineWidth',1,...
         'XLim',[0 700]), hold on
    % PC2 of color reflectance values.
    line(dataage3(:,1),dataage3(:,2),...
         'LineWidth',1);
    % Argon ages.
    errorbar(deinoi_tune3(:,1),[40 30 40 30 40 30],...
        deinoi_tune3(:,3),'Horizontal',...
        'LineStyle','None',...
        'LineWidth',1,...
        'Color',[0 0 0],...
        'Marker','+')
    for i = 1 : 6
    errorstr(i,:) = [num2str(deinoi_tune3(i,2),...
        '%06.2f\n'),' +/- ',...
        num2str(deinoi_tune3(i,3),'%05.2f\n')];
    end
    text(deinoi_tune3(:,1),[40 30 40 30 40 30]+5,errorstr,...
        'HorizontalAlignment','Center',...
        'FontSize',12)
    % Text labels.
    text(10,50,...
         agemodeltunemergestr,...
         'FontSize',12,...
         'HorizontalAlignment','Left')
    xlabel('Age (kyr BP)')
    ylabel('PC2 Color')
    % Axes Laskar 04 orbital forcing.
    axes('Position',[0.05 0.15 0.655 0.2],...
         'FontSize',12,...
         'LineWidth',1,...
         'YColor',[0.8 0.5 0.3],...
         'Color','None',...
         'YAxisLocation','Right',...
         'XLim',[0 700],...
         'YLim',[0.38 0.46]), hold on
    % Laskar 04 precession.
    line(orbital(:,1),orbital(:,4),...
         'LineWidth',1,...
         'Color',[0.8 0.5 0.3]);
    ylabel('Precession')
    % Axes LS spectrum.
    axes('Position',[0.825 0.15 0.15 0.2],...    
         'Box','On',...
         'FontSize',12,...
         'LineWidth',1,...
         'XLim',[0 0.1],...
         'YLim',[0 2500])
    line(f3,px3,...
        'LineWidth',1)
    line([0.0094 0.0094],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0244 0.0244],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0435 0.0435],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    xlabel('Frequency (1/kyr)')
    ylabel('Power')

% Display subplot labels A-E.

    axes('Position',[0.05 0.15 0.925 0.8],...
         'Color','None',...
         'LineWidth',2,...
         'Visible','Off'), hold on
    text(0.69,0.97,...
         'A',...
         'FontSize',18)
    text(0.69,0.595,...
         'C',...
         'FontSize',18)
    text(0.69,0.22,...
         'E',...
         'FontSize',18)
    text(0.9825,0.97,...
         'B',...
         'FontSize',18)
    text(0.9825,0.595,...
         'D',...
         'FontSize',18)
    text(0.9825,0.22,...
         'F',...
         'FontSize',18)

    printname = strcat("DirFiguresAnalyzing/",...
        "trauth_agemodels_supplfigs_08_analysis_mht",...
        num2str(agemodeltune(1,:)),".png");
    print(printname,'-dpng','-r300')

% Display spectral analysis results only.

    figure('Color',[1 1 1],...
         'Position',[50 500 1600 400])

    % Age Model RRMarch2021.

    % Axes LS spectrum.
    axes('Position',[0.1 0.2 0.22 0.6],...    
         'Box','On',...
         'FontSize',12,...
         'LineWidth',1,...
         'XLim',[0 0.1],...
         'YLim',[0 2500])
    line(f2,px2,...
        'LineWidth',1)
    line([0.0094 0.0094],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0244 0.0244],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0435 0.0435],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    xlabel('Frequency (1/kyr)')
    ylabel('Power')

    % Age Model MUBAWA.

    % Axes LS spectrum.
    axes('Position',[0.4 0.2 0.22 0.6],...    
         'Box','On',...
         'FontSize',12,...
         'LineWidth',1,...
         'XLim',[0 0.1],...
         'YLim',[0 2500])
    line(f2,px2,...
        'LineWidth',1)
    line([0.0094 0.0094],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0244 0.0244],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0435 0.0435],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    xlabel('Frequency (1/kyr)')
    ylabel('Power')

    % Age Model RRMarch2021+MHTXXX.

    % Axes LS spectrum.
    axes('Position',[0.7 0.2 0.22 0.6],...    
         'Box','On',...
         'FontSize',12,...
         'LineWidth',1,...
         'XLim',[0 0.1],...
         'YLim',[0 2500])
    line(f3,px3,...
        'LineWidth',1)
    line([0.0094 0.0094],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0244 0.0244],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0435 0.0435],[0 2500],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    xlabel('Frequency (1/kyr)')
    ylabel('Power')

% Display subplot labels A-E.

    axes('Position',[0.1 0.2 0.82 0.6],...
         'Color','None',...
         'LineWidth',2,...
         'Visible','Off'), hold on
    text(0.245,0.9,...
         'A',...
         'FontSize',24)
    text(0.61,0.9,...
         'B',...
         'FontSize',24)
    text(0.975,0.9,...
         'C',...
         'FontSize',24)
    text(0.01,0.9,...
         'RRMarch2021',...
         'FontSize',12,...
         'HorizontalAlignment','Left')
    text(0.375,0.9,...
         'MUBAWA',...
         'FontSize',12,...
         'HorizontalAlignment','Left')
    text(0.74,0.9,...
         agemodeltunemergestr,...
         'FontSize',12,...
         'HorizontalAlignment','Left')

    printname = strcat("DirFiguresAnalyzing/",...
        "trauth_agemodels_figure_09_spectra_mht",...
        num2str(agemodeltune(1,:)),".png");
    print(printname,'-dpng','-r300')

