%% Script 5: Importing and processing the Chew Bahir CHB14-2 XRF data.
% 
% Trauth, M.H., Asrat, A., Fischer, M., Foerster, V., Kaboth-Bahr, S.,
% Lamb, H.F., Marwan, N., Roberts, H.M., Schaebitz, F., 2024, Combining
% orbital tuning and direct dating approaches to age-depth model
% development for Chew Bahir, Ethiopia. Quaternary Science Advances
% 
% Martin H Trauth 7 June 2024

% Clear workspace, clear command window and close figure windows.

    clear, clc, close all

% Create directories.

    warning('off','MATLAB:MKDIR:DirectoryExists');

    mkdir DirResultsLongCores

% Define variable to be exported, e.g. varexport = 7 for potassium.

    varexport = 7;

% Define all base ages.

   allbaseages = 550:10:570;

% Loop.

   for loopi1 = 1 : length(allbaseages)/3

% Define tuned age models to be used.

   agemodeltune    = allbaseages(1,1+3*(loopi1-1):3*(loopi1))

% Create character string for all age models.
    agemodelstring = [...
        "rrmarch2021";...
        "mubawa";...
        strcat("rrmarch2021_mht",num2str(agemodeltune(1)));...
        strcat("rrmarch2021_mht",num2str(agemodeltune(2)));...
        strcat("rrmarch2021_mht",num2str(agemodeltune(3)));...
        ];

% Clear workspace, clear command window and close figure windows.

    for loopi2 = 1 : 5

    clearvars -except loopi* agemodeltune agemodelstring varexport allbaseages
    close all
    
% Read age model tie points and adjust agemodelmax and set preferences.
    
    agemodeloption = loopi2; % Choose age model:
                            % 1 = rrmarch2021
                            % 2 = mubawa
                            % 3 = rrmarch2021+mhtXXX
                            % 4 = rrmarch2021+mhtXXX
                            % 5 = rrmarch2021+mhtXXX

    script_read_agemodel

    agemodelmin =   2;      % Minimum age (in kyrs).
    agemodelmax = max(agemodeltiepoints(:,2));  % Maximum age (in kyrs).
    agemodelres = 0.1;      % Resolution of time axis (in kyrs).

    inttype = 'linear';     % Interpolation method.
    exttype = 'extrap';     % Extrapolation method.

% Importing Chew Bahir XRF data.

    script_read_xrf_age

% Exporting XRF data.

    % Export XRF element defined in |varexport| data vs. depth.
    data_chb14_2(:,1) = dataxrf(:,1);          % Depth
    data_chb14_2(:,2) = dataxrf(:,varexport);  % Variable
    filename = strcat("DirResultsLongCores/data_chb14_2_depth_",...
        agemodelstring(loopi2,:),".txt");
    save(filename,'data_chb14_2','-ascii')
    
    % Export XRF element defined in |varexport| data vs. age.
    data_chb14_2_age(:,1) = dataxrfage(:,1);          % Age
    data_chb14_2_age(:,2) = dataxrfage(:,varexport);  % Variable
    filename = strcat("DirResultsLongCores/data_chb14_2_age_orig_",...
        agemodelstring(loopi2,:),".txt");
    save(filename,'data_chb14_2_age','-ascii')
    
    % Export XRF element defined in |varexport| data vs. evenly spaced age.
    data_chb14_2_age_intp(:,1) = dataxrfageintp(:,1);          % Age
    data_chb14_2_age_intp(:,2) = dataxrfageintp(:,varexport);  % Variable
    filename = strcat("DirResultsLongCores/data_chb14_2_age_intp_",...
        agemodelstring(loopi2,:),".txt");
    save(filename,'data_chb14_2_age_intp','-ascii')

% End for loop

    end

    end







