%% Script S3: Script to display the tuning results
% 
% Trauth, M.H., Asrat, A., Fischer, M., Foerster, V., Kaboth-Bahr, S.,
% Lamb, H.F., Marwan, N., Roberts, H.M., Schaebitz, F., 2024, Combining
% orbital tuning and direct dating approaches to age-depth model
% development for Chew Bahir, Ethiopia. Quaternary Science Advances
% 
% Martin H Trauth 7 June 2024

% Display the results.

    figure('Color',[1 1 1],...
        'Position',[100 200 1600 800])

% PC2 of color reflectance values vs. splice depth.

    axes('Position',[0.05 0.75 0.655 0.2],...
        'Box','On',...
        'FontSize',12,...
        'LineWidth',1,...
        'XLim',[0 340]), hold on
    line(data(:,1),data(:,2),...
        'LineWidth',1);
    titlestr = ['Initial Base Age = ',num2str(baseage),...
        ' kyr | Spacing = ',num2str(intv),' kyr | Filter Passband = [',...
        num2str(cutoff),'] kyr'];
    xlabel('Composite Depth (m)')
    ylabel('–PC2(Color)')
    title(titlestr,'FontWeight','Normal')
    lgd = legend('–PC2(Color)');
    lgd.FontSize = 12;
    lgd.Box = 'Off';
    lgd.Location = 'northwest';

% PC2 of color reflectance values vs. tuned age.

    axes('Position',[0.05 0.45 0.655 0.2],...
        'Box','On',...
        'FontSize',12,...
        'LineWidth',1,...
        'XLim',XLimPlot), hold on
    line(dataiii_tune(:,1),dataiii_tune(:,2),...
        'LineWidth',1);
    xlabel('Tuned Age (kyr)')
    ylabel('–PC2(Color)')
    lgd = legend('–PC2(Color)');
    lgd.FontSize = 12;
    lgd.Box = 'Off';
    lgd.Location = 'northwest';

% Bandpassed PC2 of color reflectance values and Laskar 04 precession.

    axes('Position',[0.05 0.10 0.655 0.25],...
        'Box','On',...
        'FontSize',12,...
        'LineWidth',1,...
        'XLim',XLimPlot), hold on
    % Ages reference lines
    line([deino(:,2) deino(:,2)],[-8 8],...
        'LineWidth',1,...
        'LineStyle',':',...
        'Color',[0 0 0])
    % Bandpassed PC2 of color reflectance values.
    yyaxis left
    line(dataiiid_tune(:,1),dataiiid_tune(:,2),...
        'LineWidth',1,...
        'Color',[0 0.4470 0.7410]);
    line(dataiiid_tune(locs1,1),pks1,...
        'LineStyle','none',...
        'Marker','o',...
        'MarkerEdgeColor',[0.8 0.5 0.3],...
        'MarkerFaceColor',[0.8 0.5 0.3])
    clear labels1
    for i = 1 : length(pks1)
       labels1(i,:) = [sprintf('%02.0f',i)];
    end
    % Add more numbers to [-5 -3 -3 -5 -3 -5] if you add more ages. We
    % display 1s and 2s errorbars
    errorbar(deinoi_tune(:,1),[-5 -3 -3 -5 -3 -5]-1,...
        2*deinoi_tune(:,3),'Horizontal',...
        'LineStyle','None',...
        'Color',[0 0 0],...
        'LineWidth',0.3,...
        'Marker','+')
    errorbar(deinoi_tune(:,1),[-5 -3 -3 -5 -3 -5]-1,...
        deinoi_tune(:,3),'Horizontal',...
        'LineStyle','None',...
        'Color',[0 0 0],...
        'LineWidth',1,...
        'Marker','+')
    clear errorstr
    % Increase the 6 to a higher number if you add more ages.
    for i = 1 : 6
    errorstr(i,:) = [num2str(deinoi_tune(i,2),'%06.2f\n'),' +/- ',...
        num2str(deinoi_tune(i,3),'%05.2f\n')];
    end
    % Add more numbers to [-5 -3 -3 -5 -3 -5] if you add more ages.
    text(deinoi_tune(:,1),[-5 -3 -3 -5 -3 -5],errorstr,...
        'HorizontalAlignment','Center',...
        'FontSize',12)
    set(gca,'YLim',YLimPlot)    
    ylabel('–PC2(Color)')
    % Laskar 04 precession.
    yyaxis right
    set(gca,'YColor',[0.8 0.5 0.3])
    line(orbitaliii(:,1),orbitaliii(:,3),...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3]), hold on
    line(orbitaliii(locs2,1),pks2,...
        'LineStyle','none',...
        'Color',[0.8 0.5 0.3],...
        'Marker','o',...
        'MarkerEdgeColor',[0.8 0.5 0.3],...
        'MarkerFaceColor',[0.8 0.5 0.3])
    clear labels2
    for i = 1 : length(pks2)
       labels2(i,:) = [sprintf('%02.0f',i)];
    end
    text(orbitaliii(locs2(1:length(pks1)),1),...
        pks2(1:length(pks1))+0.04,labels1,...
        'HorizontalAlignment','Center',...
        'FontSize',12)
    set(gca,'YLim',[-0.1 0.08])   
    xlabel('Age (kyr)')
    ylabel('Precession')
    lgd = legend('','','','','','','–PC2(Color)','Peaks',...
        'Age Dates','','Precession');
    lgd.FontSize = 12;
    lgd.Box = 'Off';
    lgd.Location = 'southwest';

% Display power spectrum of PC2 of color vs. splice depth.

    axes('Position',[0.775 0.75 0.2 0.2],...
        'Box','On',...
        'FontSize',12,...
        'LineWidth',1,...
        'XLim',[0 0.2]), hold on
    line(f_orig,abs(Pxx_orig),...
        'LineWidth',1)
    xlabel('Wave Number (1/m)')
    ylabel('Power')
    
% Display power spectrum of PC2 of color vs. tuned age.

    axes('Position',[0.775 0.45 0.2 0.2],...
        'Box','On',...
        'FontSize',12,...
        'LineWidth',1,...
        'XLim',[0 0.1]), hold on
    line(f_tuned,abs(Pxx_tuned),...
        'LineWidth',1)
    line([0.0094 0.0094],[0 max(get(gca,'YLim'))],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0244 0.0244],[0 max(get(gca,'YLim'))],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    line([0.0435 0.0435],[0 max(get(gca,'YLim'))],...
        'LineStyle','-',...
        'LineWidth',1,...
        'Color',[0.8 0.5 0.3])
    xlabel('Frequency (1/kyr)')
    ylabel('Power')

% Display subplot labels A-U.

    axes('Position',[0.775 0.15 0.2 0.2],...
         'Color','None',...
         'LineWidth',1,...
         'XColor','None',...
         'Visible','Off'), hold on
    annotation('rectangle',...
         [0.945 0.15 0.03 0.05],...
         'LineWidth',1)
    text(0.9,0.13,...
         abclabels(loopi),...
         'FontSize',22)




