%% Script S4: Script to compare the K records of CB01+03 and CHB14-2
% 
% Trauth, M.H., Asrat, A., Fischer, M., Foerster, V., Kaboth-Bahr, S.,
% Lamb, H.F., Marwan, N., Roberts, H.M., Schaebitz, F., 2024, Combining
% orbital tuning and direct dating approaches to age-depth model
% development for Chew Bahir, Ethiopia. Quaternary Science Advances
% 
% Martin H Trauth 7 June 2024

% Colors.

    colors = [
        0 114 189
        217 83 25
        237 177 32
        126 47 142
    ]./255;
    
% Create Figure Window.

    figure('Color',[1 1 1],'Position',[50 100 1200 600])
    
    ax1 = axes('Position',[0.10 0.10 0.8 0.85],...
        'XLim',[0 70],...
        'LineWidth',1,...
        'Color','None',...
        'Visible','Off'); hold on
    line(ax1,[20 20],[0 1],...
        'LineWidth',1,...
        'Color',[0.85 0.85 0.85])

% Normalized potassium values of short cores CB01+03 vs. the age model of
% the short cores CB01+03.

    ax2 = axes('Position',[0.10 0.65 0.8 0.3],...
        'YDir','reverse', ...
        'XLim',[0 70],...
        'XTick',[],...
        'XColor','None',...
        'LineWidth',1,...
        'FontSize',12,...
        'Color','none'); hold on
    line(ax2,data_cb01(:,1),data_cb01(:,2),...
        'LineWidth',1,...
        'Color',colors(1,:))
    line(ax2,[11.7 12.9],[-2.2 -2.2],...
        'LineWidth',1,...
        'Color',[0 0 0])
    text(ax2,12.3,-2.6,...
        'YDS',...
        'FontSize',8,...
        'HorizontalAlignment','Center')
    line(ax2,[5.5 15],[-3 -3],...
        'LineWidth',1,...
        'Color',[0 0 0])
    text(ax2,11.25,-3.4,...
        'AHP',...
        'FontSize',8,...
        'HorizontalAlignment','Center')
    ylabel(ax2,'Potassium', ...
        'FontSize',12)
    legend('CB01+CB03',...
        'Location','East',...
        'FontSize',8,...
        'Box','Off')
   
% Normalized potassium values of long composite core CHB14-2 using the
% merged age model RRMarch2021+MHT560.
 
    ax3 = axes('Position',[0.10 0.40 0.8 0.3],...
        'YDir','reverse', ...
        'XLim',[0 70],...
        'XTick',[],...
        'XColor','None',...
        'YAxisLocation','right', ...
        'FontSize',12,...
        'LineWidth',1,...
        'Color','none'); hold on
    line(ax3,data_cbh14(:,1),data_cbh14(:,2), ...
        'LineWidth',1, ...
        'Color',colors(1,:))
    line(ax3,[9 7.05],[-2.2 -2.2],...
        'LineWidth',1,...
        'Color',[0 0 0])
    text(ax3,8.0250,-2.6,...
        'YDS',...
        'FontSize',8,...
        'HorizontalAlignment','Center')
    line(ax3,[1.94 10.7],[-3 -3],...
        'LineWidth',1,...
        'Color',[0 0 0])
    text(ax3,6.34,-3.4,...
        'AHP',...
        'FontSize',8,...
        'HorizontalAlignment','Center')
    ylabel(ax3,'Potassium', ...
        'FontSize',12)
    legendstr = strcat("CHB14-2 RRMarch2021+MHT",...
         num2str(agemodeltune(1)));
    legend(legendstr,...
        'Location','Southeast',...
        'FontSize',8,...
        'Box','Off')
 
% Normalized potassium values of merged short cores CB01+03 vs. the age
% model of the short cores CB01+03 and long composite core CHB14-2 using
% the merged age model RRMarch2021+MHT560.
   
    ax4 = axes('Position',[0.10 0.10 0.8 0.3],...
        'YDir','reverse', ...
        'XLim',[0 70],...
        'FontSize',12,...
        'LineWidth',1,...
        'Color','None'); hold on
    line(ax4,data_merged(:,1),data_merged(:,2),...
        'LineWidth',1,...
        'Color',colors(2,:))
    line(ax4,[11.7 12.9],[-2.2 -2.2],...
        'LineWidth',1,...
        'Color',[0 0 0])
    text(ax4,12.3,-2.6,...
        'YDS',...
        'FontSize',8,...
        'HorizontalAlignment','Center')
    line(ax4,[5.5 15],[-3 -3],...
        'LineWidth',1,...
        'Color',[0 0 0])
    text(ax4,11.25,-3.4,...
        'AHP',...
        'FontSize',8,...
        'HorizontalAlignment','Center')
    xlabel(ax4,'Age (kyr BP)', ...
        'FontSize',12)
    ylabel(ax4,'Potassium', ...
        'FontSize',12)
    legendstr = strcat("CB01+CB03+CHB14-2 RRMarch2021+MHT",...
         num2str(agemodeltune(1)));
    legend(legendstr,...
        'Location','Southeast',...
        'FontSize',8,...
        'Box','Off')
    
% Display subplot labels A-C, the AHP and the YD.

    ax5 = axes('Position',[0.10 0.10 0.8 0.85],...
        'Color','None',...
        'Visible','Off'); hold on 
    text(0.01,0.97,...
         'A',...
         'FontSize',18)
    text(0.97,0.67,...
         'B',...
         'FontSize',18)
    text(0.01,0.31,...
         'C',...
         'FontSize',18)
 
% Save.
   
    printname = strcat("DirFiguresMergingshortlongcores/",...
        "trauth_agemodels_figure_07_potassium_age_rrmarch2021_mht",...
        num2str(agemodeltune),".png");
    
    print('-dpng','-r300',printname)
