%% Script S55: Script to compare Chew Bahir/RRMarch2021+MHT5XX with ODP 967
% 
% Trauth, M.H., Asrat, A., Fischer, M., Foerster, V., Kaboth-Bahr, S.,
% Lamb, H.F., Marwan, N., Roberts, H.M., Schaebitz, F., 2024, Combining
% orbital tuning and direct dating approaches to age-depth model
% development for Chew Bahir, Ethiopia. Quaternary Science Advances
% 
% Martin H Trauth 7 June 2024

% Colors.

    colors = [
        0 114 189
        217 83 25
        237 177 32
        126 47 142
    ]./255;

% Create Figure Window.

    figure('Color',[1 1 1],'Position',[50 100 1200 600])

% Chew Bahir CHB14-2 RRMarch2021.

    ax1 = axes('Position',[0.10 0.65 0.8 0.3],...
        'YDir','reverse',...
        'XLim',[0 700],...
        'XTick',[],...
        'XColor','None',...
        'FontSize',12,...
        'LineWidth',1,...
        'Color','None'); hold on
    line(ax1,data_cbh14_1(:,1),data_cbh14_1(:,2),...
        'LineWidth',1,...
        'Color',colors(1,:))
    text(690,-2,...
             'RRMarch2021',...
             'FontSize',12,...
             'HorizontalAlignment','Right',...
             'Color',colors(1,:))
    ylabel(ax1,'Potassium',...
        'FontSize',12)

% ODP 967.

    ax2 = axes('Position',[0.10 0.4 0.8 0.3],...
        'XLim',[0 700],...
        'XTick',[],...
        'XColor','None',...
        'YAxisLocation','right',...
        'FontSize',12,...
        'LineWidth',1,...
        'Color','none'); hold on
    line(ax2,dataodp967(:,1),dataodp967(:,5),...
        'LineWidth',1,...
        'Color',colors(1,:))
    text(690,-4.5,...
             'ODP Site 967',...
             'FontSize',12,...
             'HorizontalAlignment','Right',...
             'Color',colors(1,:))
    ylabel(ax2,'Wetness Index',...
        'FontSize',12)

% Chew Bahir CHB14-2 RRMarch2021+MHT5XX.

    ax3 = axes('Position',[0.10 0.10 0.8 0.3],...
        'YDir','reverse',...
        'XLim',[0 700],...
        'FontSize',12,...
        'LineWidth',1,...
        'Color','None'); hold on
    line(ax3,data_cbh14_3_merged(:,1),data_cbh14_3_merged(:,2),...
        'LineWidth',1,...
        'Color',colors(1,:))
    textstr = strcat(...
            "RRMarch2021+MHT",num2str(agemodeltune(1)));
    text(690,3.5,...
             textstr,...
             'FontSize',12,...
             'HorizontalAlignment','Right',...
             'Color',colors(1,:))
    xlabel(ax3,'Age (kyr BP)',...
        'FontSize',12)
    ylabel(ax3,'Potassium',...
        'FontSize',12)

% X-Axes.

    ax4 = axes('Position',[0.10 0.10 0.8 0.85],...
        'XLim',[0 700],...
        'LineWidth',1,...
        'Color','None',...
        'Visible','Off'); hold on
    text(10,0.97,...
         'A',...
         'FontSize',18)
    text(680,0.67,...
         'B',...
         'FontSize',18)
    text(10,0.32,...
         'C',...
         'FontSize',18)

% Save.

    printname = ['DirFiguresCorrelation/',...
        'trauth_agemodels_figure_08_correlation_rrmarch2021_mht',...
         num2str(agemodeltune(1)),'_and_rrmarch2021.png'];
    print('-dpng','-r300',printname)
