%% Exercise "Downloading Weather Data - Single Data"
%
% by Martin H. Trauth & Jonas Raesch, 28 Juli 2020
% http://mres.uni-potsdam.de

%%
clear, clc

%%
% Define Netatmo login and password
netatmologin    = 'your@emailaddress.com';
netatmopasswd   = 'your.password';
netatmoclientid = 'your.clientid';
netatmoclientsc = 'your.clientsecret';

% Define Netatmo refresh token
rtoken = 'your.refreshtoken';

% ThingSpeak Channel
ChannelID = yourchannelid;
writeAPIKey = 'yourwriteapikey';
readAPIKey  = 'yourreadapikey';

% MAC addresses of inside and outside modules
dID = 'yourindoormacaddress';
mID = 'youroutdoormacaddress';

%%
% Generate the Token at Netatmo.com
token = webwrite('https://api.netatmo.com/oauth2/token',...
    'Host','api.netatmo.com',...
    'Content-Type','application/x-www-form-urlencoded;charset=UTF-8',...
    'grant_type','refresh_token',...
    'client_id',netatmoclientid,...
    'client_secret',netatmoclientsc,...
    'refresh_token',rtoken,...
    'scope','read_station');

bearer = token.access_token;

%%
% Get temperature data
dID = '70:ee:50:65:0b:a0';
mID = '02:00:00:65:34:40';

tempD = ['curl -X GET "https://api.netatmo.com/api/getmeasure?'...
         'device_id=',dID,...
         '&get_favorites=false',...
         '&module_id=',mID,...
         '&scale=','max',...
         '&type=','temperature',...
         '&optimize=true'...
         '&date_end=','last',...
         '&limit=','1',...
         '&real_time=true"',...
         ' -H "accept: application/json"'...
         ' -H "Authorization: Bearer ', bearer,'"'];

[~,cout] = system(tempD);

value = strfind(cout,'{');
value = cout(value:end);
value = jsondecode(value);

time = value.body.beg_time;
Temperature = value.body.value;

clear value cout

%%
% Get humidity data
humidD = ['curl -X GET "https://api.netatmo.com/api/getmeasure?'...
         'device_id=',dID,...
         '&get_favorites=false',...
         '&module_id=',mID,...
         '&scale=','max',...
         '&type=','humidity',...
         '&optimize=true'...
         '&date_end=','last',...
         '&limit=','1',...
         '&real_time=true"',...
         ' -H "accept: application/json"'...
         ' -H "Authorization: Bearer ', bearer,'"'];

[~,cout] = system(humidD);

value = strfind(cout,'{');
value = cout(value:end);
value = jsondecode(value);

Humidity = value.body.value;

clear value cout

%%
% Converting time
timeD = datetime(time,...
    'ConvertFrom','posixtime',...
    'TimeZone', 'Europe/Berlin');

%%
% Check last time point
tsRead = thingSpeakRead(ChannelID,...
    'Fields',[1,3],...
    'ReadKey',readAPIKey,...
    'NumPoints',1,...
    'OutputFormat','Table');
timeLast = tsRead.Timestamps;
timeLast = datetime(timeLast,...
    'TimeZone', 'Europe/Berlin');

%%
% Write data to channel
if timeLast ~= timeD
    thingSpeakWrite(ChannelID,...
        [Temperature,Humidity],...
        'WriteKey',writeAPIKey,...
        'Timestamp',timeD);
    disp('yea')
else
    disp('nay')
end



