%% Exercise 8.5.5 ThingSpeak Weather Station
%
% by Martin H. Trauth, 28 Juli 2020
% http://mres.uni-potsdam.de

%%
clear, clc, close all

%%
% Variables
dstr = ["temperature";"humidity";"pressure";"CO2";"noise"];

%%
% Define Netatmo login and password
netatmologin    = 'your@emailaddress.com';
netatmopasswd   = 'your.password';
netatmoclientid = 'your.clientid';
netatmoclientsc = 'your.clientsecret';

% Define Netatmo refresh token
rtoken = 'your.refreshtoken';

% MAC addresses of inside and outside modules
dID = 'yourindoormacaddress';
mID = 'youroutdoormacaddress';

%%
% Generate the Token at Netatmo.com
token = webwrite('https://api.netatmo.com/oauth2/token',...
    'Host','api.netatmo.com',...
    'Content-Type','application/x-www-form-urlencoded;charset=UTF-8',...
    'grant_type','refresh_token',...
    'client_id',netatmoclientid,...
    'client_secret',netatmoclientsc,...
    'refresh_token',rtoken,...
    'scope','read_station');

bearer = token.access_token;

%%
% Netatmo Outdoor Module
for k = 1 : 2

str=['curl -X GET "https://api.netatmo.com/api/getmeasure?'...
     'device_id=',dID,...
     '&module_id=',mID,...
     '&scale=','5min',...
     '&type=',char(dstr(k)),...
     '&optimize=false',...
     '&date_begin=',num2str(posixtime(datetime('yesterday',...
        'TimeZone','Europe/Berlin')),10),...
     '&real_time=true"',...
     ' -H "accept: application/json"',...
     ' -H "Authorization: Bearer ', bearer,'"'];

[~,cout] = system(str);

% Extract data from character string output cout of the cURL request. This
% script inspired by a script by Bleeck S (2020) available for download at
% the MathWorks file exchange.
strQ = strfind(cout,"""");
c = 0;
for i = 3:2:length(strQ)-8
    c = c+1;
    s = cout(strQ(i)+1:strQ(i+1)-1);
    t(c) = datetime(str2double(s),...
        'ConvertFrom','posixTime',...
        'TimeZone','Europe/Berlin',....
        'Format','dd-MMM-yyyy HH:mm');
end

strL = strfind(cout,"[");
strR = strfind(cout,"]");
c = 0;
for i = 1:length(strL)
    c = c + 1;
    s = cout(strL(i)+1:strR(i)-1);
    v(c) = str2double(s);
end
v = v';
data(:,k) = v;

end
t = t';

%%
% Merge data in a single timetable called stackeddata_out.
varnames = {'Temperature_out (°C)','Humidity_out (%)'};
stackeddata_out =...
    timetable(t,data(:,1),data(:,2));
stackeddata_out.Properties.VariableNames = varnames;

figure('Position',[50 1000 800 300])
stackedplot(stackeddata_out)
title('Netatmo Outside Module')

%%
% Netatmo Indoor Module
clear t data
for k = 1 : 5

str=['curl -X GET "https://api.netatmo.com/api/getmeasure?'...
     'device_id=',dID,...
     '&module_id=',dID,...
     '&scale=','5min',...
     '&type=',char(dstr(k)),...
     '&optimize=false',...
     '&date_begin=',num2str(posixtime(datetime('yesterday',...
        'TimeZone','Europe/Berlin')),10),...
     '&real_time=true"',...
     ' -H "accept: application/json"',...
     ' -H "Authorization: Bearer ', bearer,'"'];

[~,cout] = system(str);

% Extract data from character string output cout of the cURL request. This
% script inspired by a script by Bleeck S (2020) available for download at
% the MathWorks file exchange.
strQ = strfind(cout,"""");
c = 0;
for i = 3:2:length(strQ)-8
    c = c+1;
    s = cout(strQ(i)+1:strQ(i+1)-1);
    t(c) = datetime(str2double(s),...
        'ConvertFrom','posixTime',...
        'TimeZone','Europe/Berlin',....
        'Format','dd-MMM-yyyy HH:mm');
end

strL = strfind(cout,"[");
strR = strfind(cout,"]");
c = 0;
for i = 1:length(strL)
    c = c + 1;
    s = cout(strL(i)+1:strR(i)-1);
    v(c) = str2double(s);
end
v = v';
data(:,k) = v;

end
t = t';

%%
% Merge data in a single timetable called stackeddata_in.
varnames = {'Temperature_in (°C)','Humidity_in (%)',...
    'Pressure_in (mb)', 'CO2_in (ppm)','Noise_in (dB)'};
stackeddata_in =...
    timetable(t,data(:,1),data(:,2),data(:,3),...
    data(:,4),data(:,5));
stackeddata_in.Properties.VariableNames = varnames;

figure('Position',[50 200 800 600])
stackedplot(stackeddata_in)
title('Netatmo Inside Module')

%%
% Save all outdoor and indoor data stored in timetables
clearvars -except stackeddata*
save exercise_8_6_5_data_1.mat

