%% Exercise "Downloading Weather Data - Full (1024) Data Set"
%
% by Martin H. Trauth, 28 Juli 2020
% http://mres.uni-potsdam.de

%%
clear, clc

%%
% Variables
dstr = ["temperature";"humidity"];

%%
% Define Netatmo login and password
netatmologin    = 'your@emailaddress.com';
netatmopasswd   = 'your.password';
netatmoclientid = 'your.clientid';
netatmoclientsc = 'your.clientsecret';

% Define Netatmo refresh token
rtoken = 'your.refreshtoken';

% ThingSpeak Channel
ChannelID = yourchannelid;
writeAPIKey = 'yourwriteapikey';
readAPIKey  = 'yourreadapikey';

% MAC addresses of inside and outside modules
dID = 'yourindoormacaddress';
mID = 'youroutdoormacaddress';

%%
% Generate the Token at Netatmo.com
token = webwrite('https://api.netatmo.com/oauth2/token',...
    'Host','api.netatmo.com',...
    'Content-Type','application/x-www-form-urlencoded;charset=UTF-8',...
    'grant_type','refresh_token',...
    'client_id',netatmoclientid,...
    'client_secret',netatmoclientsc,...
    'refresh_token',rtoken,...
    'scope','read_station');

bearer = token.access_token;

%%
for k = 1 : 2

str=['curl -X GET "https://api.netatmo.com/api/getmeasure?'...
     'device_id=',dID,...
     '&get_favorites=false',...
     '&module_id=',mID,...
     '&scale=','5min',...
     '&type=',char(dstr(k)),...
     '&optimize=false',...
     '&date_begin=',num2str(posixtime(datetime('yesterday',...
        'TimeZone','Europe/Berlin')),10),...
     '&real_time=true"',...
     ' -H "accept: application/json"',...
     ' -H "Authorization: Bearer ', bearer,'"'];

[~,cout] = system(str);

% Extract data from character string output cout of the cURL request
strQ = strfind(cout,"""");
c = 0;
for i = 3:2:length(strQ)-8
    c = c+1;
    s = cout(strQ(i)+1:strQ(i+1)-1);
    t(c) = datetime(str2double(s),...
        'ConvertFrom','posixTime',...
        'TimeZone','Europe/London',....
        'Format','dd-MMM-yyyy HH:mm');
end

strL = strfind(cout,"[");
strR = strfind(cout,"]");
c = 0;
for i = 1:length(strL)
    c = c + 1;
    s = cout(strL(i)+1:strR(i)-1);
    v(c) = str2double(s);
end
v = v';
data(:,k) = v;

end
t = t';

%%
% Merging data to timetable
varnames = {'Temperature (°C)','Humidity (%)'};
stackeddata =...
    timetable(t,data(:,1),data(:,2));
stackeddata.Properties.VariableNames = varnames;

%%
% Write data to channel.
thingSpeakWrite(writeChannelID,...
    stackeddata,'WriteKey',writeAPIKey);



