	PROGRAM TURBO
C	
C	MARTIN H. TRAUTH 1997
C	UNIVERSITY OF POTSDAM, DEPT. OF GEOSCIENCES
C	POTSDAM, GERMANY
C
C	ABU	= ARRAY FOR ABUNDANCE OF DIFFERENT PARTICLE TYPES IN A
C		  A CERTAIN LAYER IN INPUT.
C	BIOLEV	= LEVEL AT WHICH MIXING ROUTINE WAS EXECUTED USING THE
C		  INDICATED PROBABILITY MATRIX.
C	COLUMN	= COLUMN 1 TO 1000 IN SEDIMENT SECTION.
C	ICONT	= PROGRAM CONTROL PARAMETERS.
C		  1. NUMBER OF MIXED LAYERS.
C		  2. NUMBER OF PROBABILITY MATRICES (MAXIMUM 10).
C		  3. NUMBER OF DEPOSITED LAYERS (MAXIMUM 1150).
C		  4. NUMBER OF DIFFERENT PARTICLE TYPES (MAXIMUM 10).
C	IDMAT	= PROBABILITY MATRIX IDENTITY NUMBER (1-10).
C	IDUM	= NEGATIVE INTEGER SEED FOR RANDOM NUMBER GENERATOR.
C	INISED	= PRE-RUN DISTRIBUTION OF SEDIMENT TYPE FOR THE FIRST 50
C		  LAYERS. MUST BE SPECIFIED TO AVOID BOUNDARY PROBLEMS.
C	IROW	= ROW WITHIN PROBABILITY MATRIX.
C	ISI	= PRE-RUN DISTRIBUTION OF ISOTOPIC VALUES FOR THE FIRST
C		  50 LAYERS. MUST BE SPECIFIED TO AVOID BOUNDARY PROBLEMS.
C	IRUN	= NUMBER OF CURRENT MIXING EVENT.
C	ISDTOP	= ACTUAL SEDIMENT SURFACE.
C	ISED	= REPRESENTS SEDIMENTARY SECTION, 0 IS TOP, 1200 IS THE
C		  THE BOTTOM.
C	ISOP	= REPRESENTS ISOTOPIC VALUES, 0 IS TOP, 1200 IS THE BOTTOM.
C	ISO	= ARRAY CONTAINING ISOTOPIC VALUES.
C	ISS	= ISOTOPIC VALUES OF PARTICLES TO BE DEPOSITED.
C	ISTYP	= CONTAINS ISOTOPE VALUE DURING MIXING PROCEDURE.
C	ITYPE	= CONTAINS PARTICLE SYMBOLS DURING MIXING PROCEDURE.
C	JJNDEX	= CONTAINS ELEMENTS OF PROBABILITY MATRIX DURING MIXING
C		  PROCEDURE.
C	JNDEX	= LEVEL WHERE PARTICLE HAS TO BE MOVED.
C	LAYER	= LINE OF PROBABILITY MATRIX IN ACTION.
C	LAYNR	= NUMBER OF LAYER OF INISED TO BE DEPOSITED.
C	LEV	= SEDIMENT LAYER IN INPUT.
C	MATNO	= LEVEL AT WHICH MIXING ROUTINE WAS EXECUTED USING THE
C		  INDICATED PROBABILITY MATRIX.
C	MTXNUM	= INTEGER RANDOM NUMBER USED DURING MIXING EVENT.
C	MVALUE	= INTEGER RANDOM NUMBER USED DURING MIXING EVENT.
C	NEWTOP	= SEDIMENT SURFACE AFTER DEPOSITION OF SEDIMENT.
C	PARTIC	= ARRAY FOR PARTICLES TO BE DEPOSITED DURING RUNTIME.
C	PROB	= PROBABILITY TRANSITION MATRICES.
C	RNDM	= INTEGER RANDOM NUMBER USED IN INPUT.
C	SYMB	= SYMBOLS FOR DIFFERENT PARTICLE TYPES (DON'T USE X).
C	TYP	= PARTICLE TYPE.
C	TARG	= INITIAL SEDIMENT DISTRIBUTION IN INPUT.
C	UNIF	= REAL RANDOM NUMBERS USED DURING MIXING EVENT.
C
C	RAN2 IS A LONG PERIOD RANDOM NUMBER GENERATOR (0.0-1.0).
C	
C+++++DEFINE AND INITIALIZE ARRAYS AND VARIABLES.
C
	CHARACTER *1 ISED(1200,1000), INISED(1151:1200,1000) 
	CHARACTER *1 PARTIC(1200,1000),ITYPE,SYMB(30)
	INTEGER LAYNR(1200),MTXNUM(1200),IRUN,MZ,IX,TYP
	INTEGER BIOLEV(1200),ICONT(10),ISDTOP,NEWTOP,MM,NN
	INTEGER MVALUE(100),JNDEX,JJNDEX,MATNO,IZ,JZ,INTRAM,IDUM
	REAL PROB(10,50,50),ISS(1200,1000),ISI(1151:1200,1000)
	REAL ISOP(1200,1000),ISTYPE,UNIF,LERGO,RAN2
C
	OPEN(UNIT=10,FILE="TURBO.CON",STATUS="OLD")
	OPEN(UNIT=20,FILE="TURBO.DAT",STATUS="OLD")
	OPEN(UNIT=30,FILE="TURBO.RES",STATUS="NEW")
C
C+++++READS CONTROL PARAMETERS.
C
	WRITE(9,*) "RUNNING.... "
	READ(10,113) IDUM
	READ(10,113) ICONT(1)
	READ(10,113) ICONT(2)
	READ(10,113) ICONT(3)
	READ(10,113) ICONT(4)
	DO 1 TYP=1,ICONT(4)
	READ(10,114) SYMB(TYP)
1	CONTINUE
C
C+++++READS INPUT DATA.
C
	WRITE(9,*) "READING INPUT DATA..."
	CALL INPUT(PARTIC,INISED,ISI,ISS,IDUM,ICONT,SYMB,MTXNUM)	
	DO 2 N=1,ICONT(3)
	LAYNR(N) = 0
2	CONTINUE
	DO 3 N = 1,ICONT(3)
	BIOLEV(N) = 0
3	CONTINUE
C	
C+++++TRANSFERS THE PRE-RUN SEDIMENT DISTRIBUTION INTO ISED.
C
	DO 8 IZ=1151,1200
	DO 9 IX=1,1000
	ISED(IZ,IX) = INISED(IZ,IX)
	ISOP(IZ,IX) = ISI(IZ,IX)
9	CONTINUE
8	CONTINUE	
	ISDTOP = 1151
C
C+++++READS PROBABILITY MATRICES.
C
	WRITE(9,*) "READING PROBABILITY MATRICES..."
	DO 10 N = 1,ICONT(2)
	CALL PROBIN (PROB)
10	CONTINUE
C	
C+++++MAIN LOOP, ADDS NEW SEDIMENT, AND THEN MIXES IT.
C
	WRITE(9,*) "MAIN LOOP..."
	DO 11 IRUN = 1,ICONT(3)
	NEWTOP = ISDTOP-1
	DO 14 IX = 1,1000
	ISED(NEWTOP,IX) = PARTIC(IRUN,IX)
	ISOP(NEWTOP,IX) = ISS(IRUN,IX)
14	CONTINUE
	ISDTOP = NEWTOP
	BIOLEV(ISDTOP) = MTXNUM(IRUN)
	WRITE(9,112) IRUN,MTXNUM(IRUN)
C	
C+++++MIXING ALGORITHM.
C
	DO 16 IX = 1,1000
	DO 17 IZ = 1,ICONT(1)
	MATNO = MTXNUM(IRUN)
	NN=0
19	DO 18 JJNDEX = 1,50
	JNDEX=JJNDEX
C
C+++++RANDOM NUMBERS BETWEEN 0.00 UND 1.00
C
	UNIF=RAN2(IDUM)
	IF(UNIF .EQ. 0.) THEN 
	UNIF=1.000
	ENDIF
	IF(UNIF.LE.PROB(MATNO,IZ,JNDEX)) THEN
	NN=NN+1
	MVALUE(NN)=JNDEX
	ENDIF
18	CONTINUE
	IF (NN.EQ.0) THEN
	GOTO 19
	ENDIF
C
C+++++RANDOM NUMBERS BETWEEN 0 UND 100
C
20	UNIF=RAN2(IDUM)
	LERGO=UNIF*100.
	INTRAM=INT(LERGO)
	IF (INTRAM.GT.NN.OR.INTRAM.EQ.0) THEN
	GOTO 20
	ENDIF
	MM=INTRAM
	JNDEX=MVALUE(MM)
C
C+++++TIME SAVING SHORT CUT IF SEDIMENT ISNT'T TO BE MOVED.
C
	IF(JNDEX.EQ.IZ) GOTO 17
C
C+++++MOVING SEDIMENT.
C
	ITYPE = ISED(ISDTOP+IZ-1,IX)
	ISTYPE = ISOP(ISDTOP+IZ-1,IX)	
	DO 21 NZ = 1, IZ-1
	MZ = ISDTOP+IZ-NZ
	ISED(MZ,IX) = ISED(MZ-1,IX)
	ISOP(MZ,IX) = ISOP(MZ-1,IX)
21	CONTINUE
	DO 22 JZ = ISDTOP+1,ISDTOP+JNDEX-1
	ISED(JZ-1, IX) = ISED(JZ,IX)
	ISOP(JZ-1, IX) = ISOP(JZ,IX)
22	CONTINUE
	ISED(ISDTOP+JNDEX-1,IX) = ITYPE
	ISOP(ISDTOP+JNDEX-1,IX) = ISTYPE
17	CONTINUE
16	CONTINUE
11	CONTINUE
C
C+++++WRITE RESULTS.
C
	WRITE(9,*) "WRITING RESULTS..."
	DO 23 JZ = ISDTOP,1200
	DO 24 KK=1,4
	WRITE(30,110) JZ,(ISED(JZ,K), K=((KK-1)*250)+1,250*KK)
24	CONTINUE
23	CONTINUE
	DO 25 JZ = ISDTOP,1200
	DO 26 KK=1,40
	WRITE(30,111) JZ,(ISOP(JZ,K), K=((KK-1)*25)+1,25*KK)
26	CONTINUE
25	CONTINUE
	WRITE(9,*) "DONE"
	PAUSE
C
110	FORMAT(I4,"*",250A1)
111	FORMAT(I4,"*",25F8.3)
112	FORMAT ("EVENT ",I4,".  MATRIX ",I4)
113	FORMAT(I10)
114	FORMAT(A1)
	END


C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	
	SUBROUTINE PROBIN (PROB)
C
C*****PROBIN READS IN PROBABILITY MATRIX.
C
C+++++ADJUST PROB TO CORRESPOND TO MAIN PROGRAM.
C
	INTEGER IDMAT,IROW
	REAL PROB(10,50,50)
C
	READ(20,201) IDMAT
C
C+++++READ MATRIX.
C
	DO 1 IROW = 1,50
	READ(20,202) (PROB(IDMAT,IROW,I1), I1 = 1,25)	
	READ(20,202) (PROB(IDMAT,IROW,I1), I1 = 26,50)
1	CONTINUE
C
201	FORMAT(I2)
202	FORMAT(25(X,F3.2))
	END
	

C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

		
	SUBROUTINE INPUT(PARTIC,INISED,ISI,ISS,IDUM,ICONT,SYMB,MTXNUM)
C
C*****INPUT READS INPUT DATA.
C
	INTEGER TYP,LAYER,ABU(1200,30),INTRAM
	INTEGER RNDM,LEV,TARG,ICONT(10),IDUM,MTXNUM(1200)
	CHARACTER *1 SYMB(30),INISED(1151:1200,1000),PARTIC(1200,1000)
	REAL ISO(1200,30),ISS(1200,1000),ISI(1151:1200,1000),LERGO
C
	DO 1 N=1151,1200
	DO 2 M=1,1000
	INISED(N,M)="X"
	ISI(N,M)=0.
2	CONTINUE
1	CONTINUE
C
	DO 3 N=1,1150
	DO 4 M=1,1000
	PARTIC(N,M)="X"
	ISS(N,M)=0.
4	CONTINUE
3	CONTINUE
C
C+++++READS INPUT DATA.
C
	OPEN(UNIT=50,FILE="TURBO.INP",STATUS="OLD")
	DO 9 LEV=1,ICONT(3)
	READ (50,*) MTXNUM(LEV),(ISO(LEV,TYP),TYP=1,ICONT(4)),
     *	(ABU(LEV,TYP),TYP=1,ICONT(4))
9	CONTINUE
C
C+++++RANDOM DISTRIBUTION OF SEDIMENT ON SEDIMENT SURFACE.
C
	LL=0
	DO 12 LEV=1,ICONT(3)
	DO 13 TYP=1,ICONT(4)
	DO 14 N=1,ABU(LEV,TYP)
C
C+++++RANDOM NUMBERS BETWEEN 0 UND 1000
C
16	UNIF=RAN2(IDUM)
	LERGO=UNIF*1000.
	INTRAM=INT(LERGO)		
	IF (INTRAM.EQ.0) THEN
	INTRAM=1000
	ENDIF
	RNDM=INTRAM
	IF (PARTIC(LEV,RNDM).EQ."X") THEN
	GOTO 15
	ENDIF
	GOTO 16
15	PARTIC(LEV,RNDM)=SYMB(TYP)
	ISS(LEV,RNDM)=ISO(LEV,TYP)
14	CONTINUE
13	CONTINUE
12	CONTINUE

	DO 17 LAYER=1151,TARG
	DO 18 TYP=1,ICONT(4)
	DO 19 N=1,ABU(LAYER,TYP)
C
C+++++RANDOM NUMBERS BETWEEN 0 UND 1000
C	
21	UNIF=RAN2(IDUM)
	LERGO=UNIF*1000.
	INTRAM=INT(LERGO)
C		
	IF (INTRAM.EQ.0) THEN
	INTRAM=1000
	ENDIF
C
	IF (INTRAM.EQ.0) THEN
	INTRAM=1000
	ENDIF
	RNDM=INTRAM
	IF (INISED(LAYER,RNDM).EQ."X") THEN
	GOTO 20
	ENDIF
	GOTO 21
20	INISED(LAYER,RNDM)=SYMB(TYP)
	ISI(LAYER,RNDM)=ISO(LAYER,TYP)
19	CONTINUE
18	CONTINUE
17	CONTINUE
	RETURN
C
	END


C


C	RANDOM NUMBER GENERATOR
C	(C) COPR. 1986-92 NUMERICAL RECIPES SOFTWARE ]2WCIZ(.
C
	FUNCTION RAN2(IDUM)
	INTEGER IDUM,IM1,IM2,IMM1,IA1,IA2,IQ1,IQ2,IR1,IR2,NTAB,NDIV
	REAL RAN2,AM,EPS,RNMX
	PARAMETER (IM1=2147483563,IM2=2147483399,AM=1./IM1,IMM1=IM1-1,
     *  IA1=40014,IA2=40692,IQ1=53668,IQ2=52774,IR1=12211,IR2=3791,
     *  NTAB=32,NDIV=1+IMM1/NTAB,EPS=1.2E-7,RNMX=1.-EPS)
	INTEGER IDUM2,J,K,IV(NTAB),IY
	SAVE IV,IY,IDUM2
	DATA IDUM2/123456789/, IV/NTAB*0/, IY/0/
	IF (IDUM.LE.0) THEN
		IDUM=MAX(-IDUM,1)
		IDUM2=IDUM
		DO 1 J=NTAB+8,1,-1
			K=IDUM/IQ1
			IDUM=IA1*(IDUM-K*IQ1)-K*IR1
			IF (IDUM.LT.0) IDUM=IDUM+IM1
			IF (J.LE.NTAB) IV(J)=IDUM
1		CONTINUE
		IY=IV(1)
	ENDIF
	K=IDUM/IQ1
	IDUM=IA1*(IDUM-K*IQ1)-K*IR1
	IF (IDUM.LT.0) IDUM=IDUM+IM1
	K=IDUM2/IQ2
	IDUM2=IA2*(IDUM2-K*IQ2)-K*IR2
	IF (IDUM2.LT.0) IDUM2=IDUM2+IM2
	J=1+IY/NDIV
	IY=IV(J)-IDUM2
	IV(J)=IDUM
	IF(IY.LT.1)IY=IY+IMM1
	RAN2=MIN(AM*IY,RNMX)
	RETURN
	END
