	PROGRAM TEST
C	
C	MARTIN H. TRAUTH 1997
C	UNIVERSITY OF POTSDAM, DEPT. OF GEOSCIENCES
C	POTSDAM, GERMANY
C
C	CHRT	= ARRAY FOR SEDIMENT PARTICLES.
C	ICONT	= PROGRAM CONTROL PARAMETERS.
C		  1. SAMPLING WITH (1) OR WITHOUT (2) REPLACEMENT.
C		  2. NUMBER OF PARTICLES PER SAMPLE
C		  3. NUMBER OF DEPOSITED LAYERS (MAXIMUM 1150).
C		  4. NUMBER OF DIFFERENT SEDIMENT TYPES (MAXIMUM 10).
C	IDUM	= NEGATIVE INTEGER SEED FOR RANDOM NUMBER GENERATOR.
C	SYMB	= SYMBOLS FOR DIFFERENT PARTICLE TYPES (DON'T USE X).
C	TOP	= SEDIMENT SURFACE.
C	SUM	= SUM OF ISOTOPIC VALUES.
C	SAMPLE	= SELECTED PARTICLE PER LAYER.
C	MEAN	= MEAN OF ISOTOPIC VALUES PER SAMPLE.
C	LERGO	= REAL RANDOM NUMBER (0.0-1000.0).
C	LAYER	= SAMPLED LAYER.
C	ISOP	= ARRAY FOR ISOTOPIC VALUES.
C	ISED	= ARRAY FOR SEDIMENT PARTICLES.
C	INTRAM	= INTEGER RANDOM NUMBERS (0-1000).
C	ABU	= ABUNDANCE OF PARTICLES OF SPECIAL TYPE PER LAYER.
C	ICONT(3)	= NUMBER OF SEDIMENT LAYERS.
C	
C	RAN2 IS A LONG PERIOD RANDOM NUMBER GENERATOR (0.0-1.0).
C	
	CHARACTER *1 ISED(1200,1000),SYMB(10),CHRT(1200,1000)
	REAL ISOP(1200,1000)
	DOUBLE PRECISION MEAN(1200,10),SUM
	INTEGER SAMPLE(1000),LAYER,TYP,TOP,LAUF,ICONT(10),REPLACE
	INTEGER TOR,HAEUF(1200,10),IDUM,KIK
C
	OPEN(UNIT=10,FILE="TURBO.RES",STATUS="OLD")
	OPEN(UNIT=20,FILE="TEST.ISO",STATUS="NEW")
	OPEN(UNIT=30,FILE="TEST.ABU",STATUS="NEW")
	OPEN(UNIT=40,FILE="TEST.CON",STATUS="OLD")
C
C+++++READS CONTROL PARAMETERS.
C
	WRITE(9,*) "RUNNING.... "
	READ(40,106) IDUM
	READ(40,106) ICONT(1)
	READ(40,106) ICONT(2)
	READ(40,106) ICONT(3)
	READ(40,106) ICONT(4)
	DO 1 TYP=1,ICONT(4)
	READ(40,107) SYMB(TYP)
1	CONTINUE
C
C+++++PRE-RUN INITIATISATION.
C
	DO 30 N=1,1200
	DO 40 M=1,1000
	CHRT(N,M)="X"
40	CONTINUE
30	CONTINUE
	ICONT(4)=ICONT(4)+1
	SYMB(ICONT(4))="X"
	TOP=1151-ICONT(3)
C
C+++++READS OUTPUT FILE OF TURBO.
C
	WRITE(9,*) "READING OUTPUT FILE OF TURBO..."
	WRITE(20,101) (SYMB(TYP),TYP=1,ICONT(4))
	WRITE(30,101) (SYMB(TYP),TYP=1,ICONT(4))
	DO 3 N=TOP,1200
	DO 4 KIK=1,4
	READ(10,102) (ISED(N,K), K=((KIK-1)*250)+1,250*KIK)
4	CONTINUE
3	CONTINUE
	DO 5 N=TOP,1200
	DO 6 KIK=1,40
	READ(10,103) (ISOP(N,K), K=((KIK-1)*25)+1,25*KIK)
6	CONTINUE
5 	CONTINUE
C
C+++++SAMPLING.
C
	WRITE(9,*) "SAMPLING..."
	DO 7 LAYER=TOP,1200
	DO 8 TYP=1,ICONT(4)
	L=0
	DO 9 M=1,1000
	IF (ISED(LAYER,M).EQ.SYMB(TYP)) THEN
	L=L+1
	SAMPLE(L)=M
	ENDIF
9	CONTINUE
	HAEUF(LAYER,TYP)=L
	IF(L.EQ.0) THEN
	MEAN(LAYER,TYP)=9.99
	GOTO 8
	ENDIF
	IF(L.LT.ICONT(2)) THEN
	TOR=L
	GOTO 10
	ENDIF
	TOR=ICONT(2)	
10	SUM=0.
C
	DO 11 N=1,TOR
C
C+++++RANDOM NUMBERS.
C
12	LERGO=RAN2(IDUM)*1000.
	INTRAM=INT(LERGO)
	IF (INTRAM.EQ.0) INTRAM=1000
	IF (INTRAM.GT.L) THEN
	GOTO 12
	ENDIF
C
C+++++COUNTING AND MESSUREMENT.
C
	MM=SAMPLE(INTRAM)
	IF(REPLACE.EQ.O) THEN
	IF(CHRT(LAYER,MM).NE."X") GOTO 12
	CHRT(LAYER,MM)=SYMB(TYP)
	ENDIF
	SUM=SUM+ISOP(LAYER,MM)
11	CONTINUE
	MEAN(LAYER,TYP)=SUM/TOR
8	CONTINUE
C
C+++++WRITES RESULTS.
C
	WRITE(20,104) LAYER,(MEAN(LAYER,LAUF),LAUF=1,TYP-1)	
	WRITE(30,105) LAYER,(HAEUF(LAYER,LAUF),LAUF=1,TYP-1)
7	CONTINUE
	WRITE(9,*) "DONE..."
	PAUSE
C
101	FORMAT(X,"LEVEL",4X,10(5X,A1,3X))
102	FORMAT (5X,250A1)
103	FORMAT (5X,25F8.3)
104	FORMAT(X,I4,3X,10(F8.3,1X))
105	FORMAT(X,I4,3X,10(1X,I7,1X))
106	FORMAT(I10)
107	FORMAT(A1)
	END


C


C	RANDOM NUMBER GENERATOR
C	(C) COPR. 1986-92 NUMERICAL RECIPES SOFTWARE
C
	FUNCTION RAN2(IDUM)
	INTEGER IDUM,IM1,IM2,IMM1,IA1,IA2,IQ1,IQ2,IR1,IR2,NTAB,NDIV
	REAL RAN2,AM,EPS,RNMX
	PARAMETER (IM1=2147483563,IM2=2147483399,AM=1./IM1,IMM1=IM1-1,
     *  IA1=40014,IA2=40692,IQ1=53668,IQ2=52774,IR1=12211,IR2=3791,
     *  NTAB=32,NDIV=1+IMM1/NTAB,EPS=1.2E-7,RNMX=1.-EPS)
	INTEGER IDUM2,J,K,IV(NTAB),IY
	SAVE IV,IY,IDUM2
	DATA IDUM2/123456789/, IV/NTAB*0/, IY/0/
	IF (IDUM.LE.0) THEN
		IDUM=MAX(-IDUM,1)
		IDUM2=IDUM
		DO 1 J=NTAB+8,1,-1
			K=IDUM/IQ1
			IDUM=IA1*(IDUM-K*IQ1)-K*IR1
			IF (IDUM.LT.0) IDUM=IDUM+IM1
			IF (J.LE.NTAB) IV(J)=IDUM
1		CONTINUE
		IY=IV(1)
	ENDIF
	K=IDUM/IQ1
	IDUM=IA1*(IDUM-K*IQ1)-K*IR1
	IF (IDUM.LT.0) IDUM=IDUM+IM1
	K=IDUM2/IQ2
	IDUM2=IA2*(IDUM2-K*IQ2)-K*IR2
	IF (IDUM2.LT.0) IDUM2=IDUM2+IM2
	J=1+IY/NDIV
	IY=IV(J)-IDUM2
	IV(J)=IDUM
	IF(IY.LT.1)IY=IY+IMM1
	RAN2=MIN(AM*IY,RNMX)
	RETURN
	END

