function [YY,E,W,WK] = rls2(S,X,L,LAM,LAM1,KKK,ITER);
% The following program implements the RLS algorithm given in
% Haykin's "Adaptive Filter theory" textbook.  Its inputs are
%       prim - primary input.
%       ref  - reference input.
%       n    - filter length.
%       lam  - forgetting factor, usually 1.
%       lam1 - A large positive constant.
%       k    - # of the weight whose convergence you want to look at.
% and the outputs are
%       enn  - output error signal.
%       fil  - output of the transversal filter.
%       w1   - final filter weights.
%       wk   - convergence of the kth weight
%     Vijay Parsa,                      Work Ph: (506) 453 4966.       
%     Graduate Student,                 Home Ph: (506) 454 1794.       
%     Institute of Biomedical Engg.     Fax: (506) 453 4827.           
%     University of New Brunwick,       Email: z98t@jupiter.csd.unb.ca 
%     Fredericton, NB.                         z98t@unb.ca             
%     Canada E3B 5A3.                                                  
%                                                                      
%     corrected by M.H. Trauth Aug. 1994
%
MS=mean(S);
S=S-MS;		% Subtrahiere Mittelwert
X=X-MS;		% Dgl.
S=S(:);
X=X(:);
KKK=4;
W=zeros(L,1);		% Initialisierung
cnn=LAM1*eye(L);
N=length(X);
for j=1:ITER
for i=L:N
	TEMPY=X(i:-1:i-L+1);
	Y(i)=TEMPY'*W;
	E(i)=S(i-fix(L/2))-Y(i);
	mun=TEMPY'*cnn*TEMPY;		% Hauptroutine
	gnn=(1/(LAM+mun))*cnn*TEMPY;
	W=W+gnn*E(i);
	WK(i)=W(KKK);
	if rem(i,100)==0
		W'
	end
	cnn=(1/LAM)*(cnn-gnn*TEMPY'*cnn);
end
end
YY=Y+MS;
EEE=E;
