function [ZZZ,YYY,EEE,W1,WK]=rcanc5(action,SINPUT,XINPUT)
%
% Recursive Correlated Data Adaptive Noise Cancelling Algorithm
%
% Dies ist die vierte Fassung des RCANC, eines rekursiven adaptiven
% Filters nach Haykin (1991), Kapitel 13.
%
% Zur Verwendung mit Matlab vs. 5.3
%
% by M.H. Trauth
% Institut fuer Geowissenschaften, Universtitaet Potsdam
% Postfach 601553, D-14415 Potsdam, Germany
% Tel (49) 331-977-2288, Fax -2087
% Internet trauth@geo.uni-potsdam.de
%
% Copyright (c) Mai 1999
%
% Referenzen:
% Haykin, S. (1991): Adaptive Filter Theory.- Prentice-Hall, Englewood Cliffs,
% New Jersey: 854.
% Algorithmus implementiert ein Programm von:
% Vijay Parsa, Graduate Student, Institute of Biomedical Engg., University
% of New Brunwick, Fredericton, NB., Canada E3B 5A3, z98t@jupiter.csd.unb.ca
%
% S		=	Filtereingang Primaersignal
% X		=	Filtereingang Referenzsignal
% L		=	Filterlaenge
% DELTA		=	Initialisierungskonstante, kleine pos. Konstante
% LAMBDA	=	Erinnerungsfaktor, normalerweise 1
% KKK		=	Nummer des Filterkoeff. dessen Konv. beobachtet werden soll
% E		=	Filterausgang Fehlersignal  Rauschen
% Z		=	Filterausgang Primaersignal  Signal (ohne Rauschen)
% Y		=	Filterausgang Referenzsignal  Signal (ohne Rauschen)
% W		=	Filterkoeffizienten
% WK		=	Konvergenz des KKKten Filterkoeffizienten
% N		=	Datenlaenge
% ITER		=	Anzahl der Iterationen
%
	global L
	global DELTA
	global LAMBDA
	global KKK
	global ITER
	global XMIN
	global XMAX
	global YMIN
	global YMAX
	global filt_field
	global init_field
	global info_field
	global con_field
	global it_field
	global xmin_field
	global xmax_field
	global ymin_field
	global ymax_field
	global start_field
	global S
	global X

if nargin==0		% Nur fuer Info ohne Input Data
	action='info';
end
if nargin==2		% Start mit Input Data
	X=SINPUT;
	S=action;
	action='start';
end

% Graphikinitialisierung

if strcmp(action,'start')

figNumber=figure(...
		'NumberTitle','off',...
		'Name','Recursive Correlated Data Adaptive Noise Cancelling Algorithm',...
		'Resize','on',...
		'Pointer','arrow',...
		'Position',[100 100 800 500],...
		'Color','white');

% Fuer die Schaltflaechen

	labelColor=192/255*[1 1 1];
	top=0.95;
	bottom=0.05;
	left=0.78;
	yInitLabelPos=0.9;
	left = 0.78;
	labelWid=0.18;
	labelHt=0.04;
	btnWid = 0.18;
	btnHt=0.045;
	
% Raum zwischen Label und der Schaltflaeche fuer denselben Befehl

	btnOffset=0.00005;
	
% Raum zwischen der Schaltflaeche und dem naechsten Label

	spacing=0.005;

% Fuer die Konsole

	frmBorder=0.02;
	yPos=0.05-frmBorder;
	frmPos=[left-frmBorder yPos btnWid+2*frmBorder 0.9+2*frmBorder];
	h=uicontrol(gcf,...
		'Style','frame', ...
		'Units','normalized', ...
		'Position',frmPos, ...
		'BackgroundColor',[1 1 1]);
end

% Textfeld fuer Filterlaenge

if strcmp(action,'start')
	L=999999;
	btnNumber=1;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	filt_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','Filter length');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	filt_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','rcanc5(''change1'');');
elseif strcmp(action,'change1')
	L=str2num(get(filt_field,'String'));
	if isempty(L)
		[N1,N2]=size(S);	% Automatische Vorwahl (empirisch TRAUTH)
		NN=N2;
		if N1>N2
			NN=N1;
		end
		L=round(NN/16);
		if rem(L,2)==0
			L=L+1;
		end
		set(filt_field,'String','auto');
	else
		set(filt_field,'String',num2str(L));
	end
end

% Textfeld fuer Erinnerungsfaktor

if strcmp(action,'start')
	LAMBDA=999999;
	btnNumber=2;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	con_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','Forgetting factor');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	con_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','rcanc5(''change2'');');
elseif strcmp(action,'change2')
	LAMBDA=str2num(get(con_field,'String'));
	if isempty(LAMBDA)
		LAMBDA=1;;
		set(con_field,'String','auto');
	else
		set(con_field,'String',num2str(LAMBDA));
	end
end

% Textfeld fuer Initialisierungsfaktor

if strcmp(action,'start')
	DELTA=999999;	% Automatische Vorwahl
	btnNumber=3;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	init_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','Initialization factor');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	init_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','rcanc5(''change3'');');
elseif strcmp(action,'change3')
	DELTA=str2num(get(init_field,'String'));
	if isempty(DELTA)
		DELTA=1000;
		set(init_field,'String','auto');
	else
		set(init_field,'String',num2str(DELTA));
	end
end

% Textfeld fuer Zahl der Iterationen

if strcmp(action,'start')
	ITER=999999;	% Automatische Vorwahl
	btnNumber=4;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	it_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','Iterations');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	it_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','rcanc5(''change4'');');
elseif strcmp(action,'change4')
	ITER=str2num(get(it_field,'String'));
	if isempty(ITER)
		ITER=1000;
		set(it_field,'String','auto');
	else
		set(it_field,'String',num2str(ITER));
	end
end

% Textfelder fuer Achsenskalierung

if strcmp(action,'start')
	XMIN=999999;
	btnNumber=5;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	xmin_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','X min');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	xmin_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','rcanc5(''change5'');');
elseif strcmp(action,'change5')
	XMIN=str2num(get(xmin_field,'String'));
	if isempty(XMIN)
		set(xmin_field,'String','auto');
	else
		set(xmin_field,'String',num2str(XMIN));
	end
end

if strcmp(action,'start')
	XMAX=999999;
	btnNumber=6;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	xmax_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','X max');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	xmax_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','rcanc5(''change6'');');
elseif strcmp(action,'change6')
	XMAX=str2num(get(xmax_field,'String'));
	if isempty(XMAX)
		set(xmax_field,'String','auto');
	else
		set(xmax_field,'String',num2str(XMAX));
	end
end

if strcmp(action,'start')
	YMIN=999999;
	btnNumber=7;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	ymin_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','Y min');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	ymin_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','rcanc5(''change7'');');
elseif strcmp(action,'change7')
	YMIN=str2num(get(ymin_field,'String'));
	if isempty(YMIN)
		set(ymin_field,'String','auto');
	else
		set(ymin_field,'String',num2str(YMIN));
	end
end

if strcmp(action,'start')
	YMAX=999999;
	btnNumber=8;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	ymax_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','Y max');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	ymax_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','rcanc5(''change8'');');
elseif strcmp(action,'change8')
	YMAX=str2num(get(ymax_field,'String'));
	if isempty(YMAX)
		set(ymax_field,'String','auto');
	else
		set(ymax_field,'String',num2str(YMAX));
	end
end

% Start-Knopf

if strcmp(action,'start')

	btnNumber=9;		
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	start_field=uicontrol(gcf,...
		'Style','push', ...
		'Units','normalized', ...
		'Position',btnPos, ...
		'String','Start', ...
		'Enable','On',...
		'CallBack','rcanc5(''run'');');
elseif strcmp(action,'run')
	set(start_field,'Enable','Off');
end

% Info-Knopf

if strcmp(action,'start')
	btnNumber=10;		
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing-0.001);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	info_field=uicontrol(gcf,...
		'Style','push', ...
		'Units','normalized', ...
		'Position',btnPos, ...
		'String','Info', ...
		'Enable','On',...
		'CallBack','rcanc5(''info'');');
elseif strcmp(action,'run')
	set(info_field,'Enable','Off');
end

% Infos

if strcmp(action,'info')
	ttlStr='Correlated Data Adaptive Noise Cancelling Algorithm: Info';
	infoStr1=['                                                          '
			' by M.H. Trauth                                           '
			'                                                          '
			' Institut fuer Geowissenschaften, Universtitaet Potsdam   '
			' Postfach 601553, D-14415 Potsdam, Germany                '
			' Tel (49) 331-977-2288, Fax -2087                         '
			' Internet trauth@persius.rz.uni-potsdam.de                '
			'                                                          '
			' Copyright (c) September 1997                             '
			'                                                          '
			'                                                          '
			];
	infoStr2=['                                                          '
			' Der RCANC bietet eine rekursive adaptive Filterung von   '
			' aequidistanten Zeitreihen.                               '
			' fahren.                                                  '
			' Es werden zwei parallele Reihen benoetigt:               '
			' Die erste Reihe ist das Primaersignal, das unter Zuhilfe-'
			' nahme der zweiten Reihe, dem Referenzsignal gefiltert    '
			' wird.                                                    '
			' Das Programm RCANC wird durch folgenden Befehl gestartet:'
			'                                                          '
			' rcanc5(PRIM,REFZ);                                       '
			'                                                          '
			' Die Ergebnisse werden auf der Festplatte in Files mit    '
			' Namen FPRIM (gefiltertes Primaersignal), FREFZ (gefil-   '
			' tertes Referenzsignal) und ERROR (extrahiertes Rauschen) '
			' abgespeichert (ASCII-Format).                            '
			'                                                          '
			' Zusaetzlich werden noch Files mit Namen PRIM (Primaer-   '
			' signal), FILT (der optimale  Filter als Funktion der     '
			' Zeit) und CONV (die Entwicklung des mittleren quadrati-  '
			' schen Fehlers pro Iteration) angelegt.                   '
			];
	infoStr3=['                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			'                                                          '
			];

	cancinfo(ttlStr,infoStr1,infoStr2,infoStr3);
end

if strcmp(action,'run')
	if LAMBDA==999999		% Sollte LAMBDA noch auf auto stehen und wurde nicht geaendert.
		LAMBDA=1;
		disp(' ')
		s=[' Forgetting factor= ',num2str(LAMBDA)];
		disp(s)
	end
	if DELTA==999999		% Sollte DELTA noch auf auto stehen und wurde nicht geaendert.
		DELTA=0.0001;		% Haykin bietet hier eine emp. Empf. auf S. 384 !!!!!!!! Aendern!!
		disp(' ')
		s=[' Initialization factor= ',num2str(DELTA)];
		disp(s)
	end
	if L==999999
		[N1,N2]=size(S);	% Automatische Vorwahl (empirisch TRAUTH)
		NN=N2;
		if N1>N2
			NN=N1;
		end
		L=round(NN/16);
		if rem(L,2)==0
			L=L+1;
		end
		disp(' ')
		s=[' Filter length= ',num2str(L)];
		disp(s)
	end
	if ITER==999999
		ITER=1000;
		disp(' ')
		s=[' Iterations= ',num2str(ITER)];
		disp(s)
	end
	ax=0;
	if XMIN==999999 | XMAX==999999 | YMIN==999999 | YMAX==999999
		ax=1;
	end

RS=S;
RX=X;
clear global S				% S und X sollen nun nur noch lokale Variablen sein
clear global X
X=RX;
S=RS;
[n1,n2]=size(S);			% Format der Datenreihe
N=n2;
if n1>n2				% Transposition, falls Spaltenvektor
	S=S';
	X=X';
	N=n1;
end

T=1:N;					% Zeitachse fuer Plots
Z(1:N)=zeros(size(1:N));		% Filterausgang Primaersignal
Y(1:N)=zeros(size(1:N));		% Filterausgang Referenzsignal
E(1:N)=zeros(size(1:N));		% Filterausgang Fehlersignal
MS(1:N)=mean(S).*ones(size(1:N));	% Mittelwert von SS
S=S-MS;					% Subtraktion des Mittelwerts von SS
X=X-MS;					% Subtraktion des Mittelwerts von XX

% Anfang Plotten

h1=subplot('Position',[.05 .55 .4 .35]);
title(['RCANC: Input Data.'])
if ax==0
	set(h1,'XLim',[XMIN XMAX],'YLim',[YMIN YMAX])
end
set(h1,'DefaultLineColor',[0.1 0.7 0.3],'DefaultLineLineStyle','-')
line('XData',T,'YData',S(1:N)+MS(1:N))
set(h1,'DefaultLineColor',[0.3 0.2 0.7],'DefaultLineLineStyle','-')
line('XData',T,'YData',X(1:N)+MS(1:N))
drawnow

% Ende Plotten

W=zeros(L,1);				% Filtergewichte anfaenglich Null
TEMPY=zeros(L,1);
TEMPZ=zeros(L,1);

S=S(:);					% Macht Spaltenvektor
X=X(:);
DELMAT=(1/DELTA)*eye(L);		% Der Initfaktor in Form einer Matrix
KKK=(L/2)+1;				% Zur Betrachtung des mittleren Filtergewichts

for IT=1:ITER				% Start RCANC Algorithmus, Beginn der Iteration
	for i=L:N
        TEMPY=X(i:-1:i-L+1);
		TEMPZ=S(i:-1:i-L+1);
        Y(i)=TEMPY'*W;
		Z(i)=TEMPZ'*W;
        E(i)=S(i-fix(L/2))-Y(i);
	    KAN=(1/(LAMBDA+TEMPY'*DELMAT*TEMPY))*DELMAT*TEMPY;
		WK(i,1:L)=W';
		W=W+KAN*E(i);
        DELMAT=(1/LAMBDA)*(DELMAT-KAN*TEMPY'*DELMAT);
	end

% Anfang Plotten Filterergebnisse

h2=subplot('Position',[.05 .1 .4 .35]);
title(['RCANC: Filter output after Iteration ',num2str(IT)])
if ax==0
set(h2,'XLim',[XMIN XMAX],'YLim',[YMIN YMAX])
end
set(h2,'DefaultLineColor',[0.8 0.8 0.8],'DefaultLineLineStyle','-')
line('XData',T(1:(N-(fix(L/2)))),'YData',(S(1:(N-(fix(L/2)))))'+MS((1+(fix(L/2))):N))
set(h2,'DefaultLineColor',[0.1 0.7 0.3],'DefaultLineLineStyle','-')
line('XData',T(1:(N-(fix(L/2)))),'YData',Y((1+(fix(L/2))):N)+MS((1+(fix(L/2))):N))
set(h2,'DefaultLineColor',[0.3 0.2 0.7],'DefaultLineLineStyle','-')
line('XData',T(1:(N-(fix(L/2)))),'YData',Z((1+(fix(L/2))):N)+MS((1+(fix(L/2))):N))
drawnow
delete(h2)

% Ende Plotten Filterergebnisse

for I=1:N	% Phasenkorrektur
		if I<=fix(L/2)
			YYY(I)=0;
			ZZZ(I)=0;
			EEE(I)=0;
			WK(I,1:L)=zeros(size(1:L));
		elseif I>N-fix(L/2)
			YYY(I)=0;
			ZZZ(I)=0;
			EEE(I)=0;
			WK(I,1:L)=zeros(size(1:L));
		else
			YYY(I)=Y(I+fix(L/2));
			ZZZ(I)=Z(I+fix(L/2));
			EEE(I)=abs(E(I+fix(L/2)));
			WK(I,1:L)=WK(I+fix(L/2),1:L);
		end
			YYY(I)=YYY(I)+MS(I);	% Addition des Mittelwertes
			ZZZ(I)=ZZZ(I)+MS(I);
			SSS(I)=S(I)+MS(I);
	end
	
	Y(1:N)=zeros(size(1:N));		% Filterausgang wieder auf Null gesetzt.
	Z(1:N)=zeros(size(1:N));

	YYY=YYY(:);				% Macht Spaltenvektoren
	ZZZ=ZZZ(:);
	SSS=SSS(:);
	EEE=EEE(:);

	MER(IT)=mean(EEE((fix(L/2)):(N-fix(L/2))).^2);	% Mittlerer quadr. Fehler
	MER=MER(:);				% Macht Spaltenvektor 

	save MER.m MER -ascii
	save FREFZ.m YYY -ascii
	save FPRIM.m ZZZ -ascii
	save PRIM.m SSS -ascii
	save ERROR.m EEE -ascii
	save FILT.m WK -ascii
	
% Anfang Plotten Endergebnisse

if IT==ITER	
h3=subplot('Position',[.05 .1 .4 .35]);
title(['RCANC: Filter output after iteration ',num2str(IT)])
if ax==0
set(h3,'XLim',[XMIN XMAX],'YLim',[YMIN YMAX])
end
set(h3,'DefaultLineColor',[0.8 0.8 0.8],'DefaultLineLineStyle','-')
line('XData',T,'YData',SSS')
set(h3,'DefaultLineColor',[0.3 0.2 0.7],'DefaultLineLineStyle','-')
line('XData',T,'YData',ZZZ')
set(h3,'DefaultLineColor',[1 0 0],'DefaultLineLineStyle','-')
line('XData',T,'YData',EEE')
drawnow
h4=subplot('Position',[.5 .1 .22 .35]);
title(['Learning Curve after iteration ',num2str(IT)])
set(h4,'DefaultLineColor',[1 0 0],'DefaultLineLineStyle','-')
line('XData',(1:ITER),'YData',MER')
end

% Ende Plotten Endergebnisse

end
end
