% Example to run the CANC and RCANC adaptive filters
% 
% Trauth, M.H. (1998) Noise removal from duplicate paleoceanographic
% time-series: The use of adaptive filtering techniques. Mathematical
% Geology, 30(5), 557-574.
%
% Trauth, M.H. (2021) MATLAB Recipes for Earth Sciences – Fifth Edition.
% Springer International Publishing, ~500 p., Supplementary Electronic
% Material, Hardcover, ISBN: 978-3-030-38440-1

% Martin H. Trauth 6 August 2021

clc, close all, clear

%%
x = 0 : 0.1 : 100;
y = sin(x);
rng(0)
yn1 = y + 0.5*randn(size(y));
yn2 = y + 0.5*randn(size(y));

canc10(yn1,yn2)


%%
clear
x = 0 : 0.1 : 100;
y = sin(x);
rng(0)
yn1 = y + 0.5*randn(size(y));
yn2 = y + 0.5*randn(size(y));

rcanc5(yn1,yn2)


