clear, clc, close all
data = load('data_T17049_6.txt');

%%
figure1 = figure(...
    'Position',[200 200 800 600],...
    'Color',[1 1 1]);
axes1 = axes(...
    'Box','on',...
    'Units','Centimeters',...
    'Position',[2 2 10 6],...
    'LineWidth',0.6,...
    'FontName','Helvetica',...
    'FontSize',8,...
    'YDir','Reverse');
line1 = line(data(:,1),data(:,2),...
    'LineWidth',0.75,...
    'Color',[0 0.4453 0.7383]);
line2 = line(data(:,1),data(:,3),...
    'LineWidth',0.75,...
    'Color',[0.8477 0.3242 0.0977]);
text(150,0.8,'Core 17049-6')
text(150,1.0,'G. bulloides',...
    'FontAngle','Italic')
xlabel1 = xlabel(...
    'Depth in Sediment (meters)',...
    'FontName','Helvetica',...
    'FontSize',8);
ylabel1 = ylabel(...
    '\delta ^{18}O (%^{_o} vs. PDB)',...
    'FontName','Helvetica',...
    'FontSize',8);

print -dpng -r300 Core_17049_6.png