clear, close all

x = 0 : 0.1 : 100; x = x';
y = sin(x);

rng(0)
yn1 = y + 0.5*randn(size(y));
yn2 = y + 0.5*randn(size(y));

% Ohne Rauschen ab 500
yn1(501:1001) =  y(501:1001);
yn2(501:1001) =  y(501:1001);

% Mit ein bisschen Rauschen ab 500
%yn1(501:1001) =  y(501:1001) + 0.1*randn(size(yn1(501:1001)));
%yn2(501:1001) =  y(501:1001) + 0.1*randn(size(yn2(501:1001)));

%%
% Waehle u automatisch
k = kron(yn1,yn1');
u = 1/max(eig(k))

%%
% Hier kann man auch den dritten Parameter durch u ersetzen
[zz,ee,mer,ww] = canc(yn1,yn2,0.0016,11,10);

%%
% Mittlere Filtergewichte www der gesamten Zeitreihe
www = mean(ww);

%%
% Amplitudengang (w = eigentlich Omega)
[h,w] = freqz(www,1,1024);
f = 1*w/(2*pi);

%%
% Filtern: Bei nichtscharfer Cut-Off-Frequenz kann man FILTFILT nicht
% verwenden. Deswegen mit CONV oder mit FILTER.
yn1filt = conv(yn1,www,'same');

%%
figure('Position',[50 150 500 300])
plot(1:1001,yn1,1:1001,yn2), title('Filter Input')
figure('Position',[50 550 500 300])
plot(zz), title('Filter Output')
figure('Position',[50 950 500 300])
plot(ee), title('Extracted Noise')
figure('Position',[550 150 500 300])
plot(mer), title('Mean-Squared Error/Learning Curve')
figure('Position',[550 550 500 300])
surf(ww(6:996,:)),shading interp, title('Filter Weights')
figure('Position',[550 950 500 300])
plot(www),title('Mean Filter Weights')
figure('Position',[1050 150 500 300])
plot(f,abs(h)),title('Magnitude Response')
figure('Position',[1050 550 500 300])
plot(yn1filt),title('Filter Output with Mean Filter Weights')






