function [ZZZ,YYY,EEE] = canc10(action,SINPUT,XINPUT)
%
% Correlated Data Adaptive Noise Cancelling Algorithm
%
% X kann Luecken aufweisen, die durch 999 gefuellt sind. Der Algorithmus
% filtert an diesen Stellen mit den zuvor gewonnenen Filterkoeffizienten
% weiter. S darf keine Luecken haben. Ausgegeben werden das gefilterte
% Referenzsignal YYY, das gefilterte Primaersignal ZZZ und das Errorsignal
% EEE. Es wird ein mittlerer quadratischer Fehler zur Erstellung von
% Learning Curves gemaess Haykin, S. 494, errechnet.
%
% Zur Verwendung mit Matlab vs. 5.3
%
% by M.H. Trauth
% Institut fuer Geowissenschaften, Universtitaet Potsdam
% Postfach 601553, D-14415 Potsdam, Germany
% Tel (49) 331-977-2288, Fax -2087
% Internet trauth@geo.uni-potsdam.de
%
% Copyright (c) Mai 1999
%
% Referenzen:
% Hattingh, M. (1988): A new data adaptive filtering program to remove
% noise from geophysical time- or space-series data.- Computers and
% Geosciences, 14: 467-480.
% Haykin, S. (1991): Adaptive Filter Theory.- Prentice-Hall, Englewood
% Cliffs, New Jersey: 854.
%
% W		= Filterkoeffizienten
% S		= Filtereingang Primaersignal
% X		= Filtereingang Referenzsignal
% SS		= Verschobenes Primaersignal
% XX		= Verschobenes Referenzsignal
% Z		= Filterausgang Primaersignal  Signal (ohne Rauschen)
% Y		= Filterausgang Referenzsignal  Signal (ohne Rauschen)
% E		= Filterausgang Fehlersignal  Rauschen
% L		= Filterlaenge
% U		= Konvergenzrate
% N		= Datenlaenge
% ITER		= Anzahl der Iterationen

	global L
	global U
	global ITER
	global XMIN
	global XMAX
	global YMIN
	global YMAX
	global filt_field
	global info_field
	global con_field
	global it_field
	global xmin_field
	global xmax_field
	global ymin_field
	global ymax_field
	global start_field
	global S
	global X

if nargin==0		% Nur fuer Info ohne Input Data
	action='info';
end
if nargin==2		% Start mit Input Data
	X=SINPUT;
	S=action;
	action='start';
end

% Graphikinitialisierung

if strcmp(action,'start')
figNumber=figure(...
		'NumberTitle','off',...
		'Name','Correlated Data Adaptive Noise Cancelling Algorithm',...
		'Resize','on',...
		'Pointer','arrow',...
		'Position',[100 100 800 500],...
		'Color','white');

% Fuer die Schaltflaechen

	labelColor=192/255*[1 1 1];
	top=0.95;
	bottom=0.05;
	left=0.78;
	yInitLabelPos=0.9;
	left = 0.78;
	labelWid=0.18;
	labelHt=0.04;
	btnWid = 0.18;
	btnHt=0.045;
	
% Raum zwischen Label und der Schaltflaeche fuer denselben Befehl

	btnOffset=0.00005;
	
% Raum zwischen der Schaltflaeche und dem naechsten Label

	spacing=0.015;

% Fuer die Konsole

	frmBorder=0.02;
	yPos=0.05-frmBorder;
	frmPos=[left-frmBorder yPos btnWid+2*frmBorder 0.9+2*frmBorder];
	h=uicontrol(gcf,...
		'Style','frame', ...
		'Units','normalized', ...
		'Position',frmPos, ...
		'BackgroundColor',[1 1 1]);
end

% Textfeld fuer Filterlaenge

if strcmp(action,'start')
	L=999999;
	btnNumber=1;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	filt_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','Filter length');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	filt_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','canc10(''change1'');');
elseif strcmp(action,'change1')
	L=str2num(get(filt_field,'String'));
	if isempty(L)
		[N1,N2]=size(S);	% Automatische Vorwahl (empirisch TRAUTH)
		NN=N2;
		if N1>N2
			NN=N1;
		end
		L=round(NN/16);
		if rem(L,2)==0
			L=L+1;
		end
		set(filt_field,'String','auto');
	else
		set(filt_field,'String',num2str(L));
	end
end

% Textfeld fuer Konvergenzrate

if strcmp(action,'start')
	U=999999;
	btnNumber=2;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	con_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','Convergence factor');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	con_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','canc10(''change2'');');
elseif strcmp(action,'change2')
	U=str2num(get(con_field,'String'));
	if isempty(U)
		KKK=kron(X,X');		% Hattingh, Widrow etc.
		U=1/max(eig(KKK));
		set(con_field,'String','auto');
	else
		set(con_field,'String',num2str(U));
	end
end

% Textfeld fuer Zahl der Iterationen

if strcmp(action,'start')
	ITER=999999;			% Automatische Vorwahl
	btnNumber=3;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	it_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','Iterations');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	it_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','canc10(''change3'');');
elseif strcmp(action,'change3')
	ITER=str2num(get(it_field,'String'));
	if isempty(ITER)
		ITER=1000;
		set(it_field,'String','auto');
	else
		set(it_field,'String',num2str(ITER));
	end
end

% Textfelder fuer Achsenskalierung

if strcmp(action,'start')
	XMIN=999999;
	btnNumber=4;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	xmin_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','X min');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	xmin_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','canc10(''change4'');');
elseif strcmp(action,'change4')
	XMIN=str2num(get(xmin_field,'String'));
	if isempty(XMIN)
		set(xmin_field,'String','auto');
	else
		set(xmin_field,'String',num2str(XMIN));
	end
end

if strcmp(action,'start')
	XMAX=999999;
	btnNumber=5;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	xmax_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','X max');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	xmax_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','canc10(''change5'');');
elseif strcmp(action,'change5')
	XMAX=str2num(get(xmax_field,'String'));
	if isempty(XMAX)
		set(xmax_field,'String','auto');
	else
		set(xmax_field,'String',num2str(XMAX));
	end
end

if strcmp(action,'start')
	YMIN=999999;
	btnNumber=6;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	ymin_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','Y min');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	ymin_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','canc10(''change6'');');
elseif strcmp(action,'change6')
	YMIN=str2num(get(ymin_field,'String'));
	if isempty(YMIN)
		set(ymin_field,'String','auto');
	else
		set(ymin_field,'String',num2str(YMIN));
	end
end

if strcmp(action,'start')
	YMAX=999999;
	btnNumber=7;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	ymax_text = uicontrol(gcf, ...
	'Style','text', ...
	'Units','normalized', ...
	'Position', labelPos, ...
	'BackgroundColor',[1 1 1], ...
	'ForegroundColor','black', ...
	'String','Y max');
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	ymax_field = uicontrol(gcf,...
		'Style','edit', ...
		'Units','normalized', ...
		'Position', btnPos, ...
		'String', 'auto', ...
		'CallBack','canc10(''change7'');');
elseif strcmp(action,'change7')
	YMAX=str2num(get(ymax_field,'String'));
	if isempty(YMAX)
		set(ymax_field,'String','auto');
	else
		set(ymax_field,'String',num2str(YMAX));
	end
end

% Start-Knopf

if strcmp(action,'start')
	btnNumber=8;	
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	start_field=uicontrol(gcf,...
		'Style','push', ...
		'Units','normalized', ...
		'Position',btnPos, ...
		'String','Start', ...
		'Enable','On',...
		'CallBack','canc10(''run'');');
elseif strcmp(action,'run')
	set(start_field,'Enable','Off');
end

% Info-Knopf

if strcmp(action,'start')
	btnNumber=9;
	yLabelPos=top-(btnNumber-1)*(btnHt+labelHt+spacing);
	labelPos=[left yLabelPos-labelHt labelWid labelHt];
	btnPos=[left+0.035  yLabelPos-labelHt-btnHt-btnOffset ...
		0.5*btnWid+frmBorder  btnHt];
	info_field=uicontrol(gcf,...
		'Style','push', ...
		'Units','normalized', ...
		'Position',btnPos, ...
		'String','Info', ...
		'Enable','On',...
		'CallBack','canc10(''info'');');
elseif strcmp(action,'run')
	set(info_field,'Enable','Off');
end

% Infos

if strcmp(action,'info')
	ttlStr='Correlated Data Adaptive Noise Cancelling Algorithm: Info';
	infoStr1=['                                                          '
			' by M.H. Trauth                                           '
			'                                                          '
			' Institut fuer Geowissenschaften, Universtitaet Potsdam   '
			' Postfach 601553, D-14415 Potsdam, Germany                '
			' Tel (49) 331-977-2288, Fax -2087                         '
			' Internet trauth@persius.rz.uni-potsdam.de                '
			'                                                          '
			' Copyright (c) September 1997                             '
			'                                                          '
			];
	infoStr2=['                                                          '
			' Der CANC bietet die adaptive Filterung von aequidistanten'
			' Zeitreihen nach dem Widrow-Hoff Least Mean Squares Ver-  '
			' fahren.                                                  '
			' Es werden zwei parallele Reihen benoetigt:               '
			' Die erste Reihe ist das Primaersignal, das unter Zuhilfe-'
			' nahme der zweiten Reihe, dem Referenzsignal gefiltert    '
			' wird.                                                    '
			' Das Programm CANC wird durch folgenden Befehl gestartet: '
			'                                                          '
			' canc10(PRIM,REFZ);                                       '
			'                                                          '
			' Die Ergebnisse werden auf der Festplatte in Files mit    '
			' den Namen FPRIM (gefiltertes Primaersignal), FREFZ (ge-  '
			' filtertes Referenzsignal) und ERROR (extrahiertes Rau-   '
			' schen) abgespeichert (ASCII-Format).                     '
			'                                                          '
			' Zusaetzlich werden noch Files mit Namen PRIM (Primaer-   '
			' signal) und FILT (der optimale  Filter als Funktion der  '
			' Zeit) angelegt.                                          '
			'                                                          '
			];
	infoStr3=['                                                          '
			' Es folgt eine Benutzeroberflaeche, die eine Eingabe der  '
			' Filterparameter erlaubt. Alle Parameter stehen zunaechst '
			' auf automatischem Betrieb. Dahinter verbergen sich empi- '
			' rische Formeln und Werte aus der Literatur bzw. von mir. '
			' Die automatische Wahl der Plot-Achsen wird dem Rechner   '
			' ueberlassen. Die Werte koennen in einem beliebigen Format'
			' eingegeben werden. Sie koennen ausserdem auch wieder auf '
			' auto zurueckgesetzt werden.                              '
			' Folgende Parameter sind definierbar:                     '
			'                                                          '
			' Filterlaenge: Die Filterlaenge muss eine ungerade ganze  '
			'     Zahl sein, um den Entwurf eines symmetrischen (somit '
			'     phasentreuen) Filters zu ermoeglichen.               '
			' Konvergenz: Dies ist die Schrittweite, mit der das Mini- '
			'     mum auf der Error Performance Surface gesucht wird.  '
			' Iterationen: Die Zahl der Rechenschritte bis zum Abbruch '
			'     des Rechenvorgangs.                                  '
			' Achsen: X min, X max, Y min und Y max fuer die graphische'
			'     Ausgabe der Zwischen- und Endergebnissen.            '
			'                                                          '
			' Start: Starten des eigentlichen Filteralgorithmus.       '
			];

	cancinfo(ttlStr,infoStr1,infoStr2,infoStr3);
end

if strcmp(action,'run')
	if U==999999			% Sollte U noch auf auto stehen.
		KKK=kron(X,X');		% Hattingh, Widrow etc.
		U=1/max(eig(KKK));
		disp(' ')
		s=[' Convergence factor= ',num2str(U)];
		disp(s)
	end
	if L==999999
		[N1,N2]=size(S);	% Automatische Vorwahl (empirisch TRAUTH)
		NN=N2;
		if N1>N2
			NN=N1;
		end
		L=round(NN/16);
		if rem(L,2)==0
			L=L+1;
		end
		disp(' ')
		s=[' Filter length= ',num2str(L)];
		disp(s)
	end
	if ITER==999999
		ITER=1000;
		disp(' ')
		s=[' Iterations= ',num2str(ITER)];
		disp(s)
	end
	ax=0;
	if XMIN==999999 | XMAX==999999 | YMIN==999999 | YMAX==999999
		ax=1;
	end

RS=S;
RX=X;
clear global S				% S und X sollen nur noch lokale Variablen sein
clear global X
X=RX;
S=RS;
[n1,n2]=size(S);			% Format der Datenreihe
N=n2;
if n1>n2				% Transposition, falls Spaltenvektor
S=S';
X=X';
N=n1;
end

T=1:N;					% Zeitachse fuer Plots
W(1:L)=zeros(size(1:L));	% Filterkoeffizienten anfaenglich Null
XX(1:L)=zeros(size(1:L));	% Verschobenes Teilstueck Referenzsignal
SS(1:L)=zeros(size(1:L));	% Verschobenes Teilstueck Primaersignal
Z(1:N)=zeros(size(1:N));	% Filterausgang Primaersignal
Y(1:N)=zeros(size(1:N));	% Filterausgang Referenzsignal
E(1:N)=zeros(size(1:N));	% Filterausgang Fehlersignal
ORS=S;					% Originalsignal speichern fuer Fehlerberechnung
MIT=mean(S);				% Wird bei Filtern lueckenhafter Daten benoetigt
MS(1:N)=mean(S).*ones(size(1:N));	% Mittelwert von S
S=S-MS;					% Subtraktion des Mittelwerts von S
ORS=ORS-MS;				% Subtraktion des Mittelwerts von ORS
X=X-MS;					% Subtraktion des Mittelwerts von X

% Anfang Plotten

h1=subplot('Position',[.05 .55 .4 .35]);
title(['CANC: Input Data.'])
if ax==0
	set(h1,'XLim',[XMIN XMAX],'YLim',[YMIN YMAX])
end
set(h1,'DefaultLineColor',[0.1 0.7 0.3],'DefaultLineLineStyle','-')
line('XData',T,'YData',S(1:N)+MS(1:N))
set(h1,'DefaultLineColor',[0.3 0.2 0.7],'DefaultLineLineStyle','-')
line('XData',T,'YData',X(1:N)+MS(1:N))
drawnow

% Ende Plotten

for IT=1:ITER				% Start CANC Algorithmus, Beginn der Iteration
	for I=(L+1):(N+1)		% Filterschleife
		for K=1:L
			XX(K)=X(I-K);	% Verschiebe Referenzsignal
			SS(K)=S(I-K);	% Verschiebe Primaersignal
        end
        for J=1:L			% Eigentliches Filtern
		WWW(I-1,J)=W(J);
		if all(XX~=999-MIT.*ones(size(1:L)))	% Luecke? Dann kein Filtern!
			Y(I-1)=Y(I-1)+W(J).*XX(J);	% Filtern des Referenzsignals
		else
			Y(I-1)=MIT;
		end
		Z(I-1)=Z(I-1)+W(J).*SS(J);		% Filtern des Originalsignals
        end
        E(I-1)=ORS(I-1-(fix(L/2)))-Y(I-1);		% Primsignal verschieben und Fehler
		if all(XX~=999-MIT.*ones(size(1:L)))	% Luecke? Keine Filteranpassung!
		for J=1:L
			W(J)=W(J)+2.*U.*E(I-1).*XX(J);	% Filteranpassung nach Widrow-Hoff
        end
        end
    end

% Anfang Plotten Filterergebnisse

h2=subplot('Position',[.05 .1 .4 .35]);
title(['CANC: Filter output after Iteration ',num2str(IT)])
if ax==0
set(h2,'XLim',[XMIN XMAX],'YLim',[YMIN YMAX])
end
set(h2,'DefaultLineColor',[0.8 0.8 0.8],'DefaultLineLineStyle','-')
line('XData',T(1:(N-(fix(L/2)))),'YData',S(1:(N-(fix(L/2))))+MS((1+(fix(L/2))):N))
set(h2,'DefaultLineColor',[0.1 0.7 0.3],'DefaultLineLineStyle','-')
line('XData',T(1:(N-(fix(L/2)))),'YData',Y((1+(fix(L/2))):N)+MS((1+(fix(L/2))):N))
set(h2,'DefaultLineColor',[0.3 0.2 0.7],'DefaultLineLineStyle','-')
line('XData',T(1:(N-(fix(L/2)))),'YData',Z((1+(fix(L/2))):N)+MS((1+(fix(L/2))):N))
drawnow
delete(h2)

% Ende Plotten Filterergebnisse

	for I=1:N				% Phasenkorrektur
		if I<=fix(L/2)
			YYY(I)=0;
			ZZZ(I)=0;
			EEE(I)=0;
			WWW(I,1:L)=zeros(size(1:L));
		elseif I>N-fix(L/2)
			YYY(I)=0;
			ZZZ(I)=0;
			EEE(I)=0;
			WWW(I,1:L)=zeros(size(1:L));
		else
			YYY(I)=Y(I+fix(L/2));
			ZZZ(I)=Z(I+fix(L/2));
			EEE(I)=abs(E(I+fix(L/2)));
			WWW(I,1:L)=WWW(I+fix(L/2),1:L);
		end
			YYY(I)=YYY(I)+MS(I);	% Addition des Mittelwertes
			ZZZ(I)=ZZZ(I)+MS(I);
			SSS(I)=S(I)+MS(I);
	end

	Y(1:N)=zeros(size(1:N));		% Filterausgang wieder auf Null gesetzt.
	Z(1:N)=zeros(size(1:N));

	YYY=YYY(:);				% Macht Spaltenvektoren
	ZZZ=ZZZ(:);
	SSS=SSS(:);
	EEE=EEE(:);

	MER(IT)=mean(EEE((fix(L/2)):(N-fix(L/2))).^2);	% Mittlerer quadr. Fehler
	MER=MER(:);					% Macht Spaltenvektor 

	save MER.m MER -ascii
	save FREFZ.m YYY -ascii
	save FPRIM.m ZZZ -ascii
	save PRIM.m SSS -ascii
	save ERROR.m EEE -ascii
	save FILT.m WWW -ascii

% Anfang Plotten Endergebnisse

if IT==ITER	
h3=subplot('Position',[.05 .1 .4 .35]);
title(['CANC: Filter output after iteration ',num2str(IT)])
if ax==0
set(h3,'XLim',[XMIN XMAX],'YLim',[YMIN YMAX])
end
set(h3,'DefaultLineColor',[0.8 0.8 0.8],'DefaultLineLineStyle','-')
line('XData',T,'YData',SSS')
set(h3,'DefaultLineColor',[0.3 0.2 0.7],'DefaultLineLineStyle','-')
line('XData',T,'YData',ZZZ')
set(h3,'DefaultLineColor',[1 0 0],'DefaultLineLineStyle','-')
line('XData',T,'YData',EEE')
drawnow
h4=subplot('Position',[.5 .1 .22 .35]);
title(['Learning Curve after iteration ',num2str(IT)])
set(h4,'DefaultLineColor',[1 0 0],'DefaultLineLineStyle','-')
line('XData',(1:ITER),'YData',MER')
end

% Ende Plotten Endergebnisse

end
end
