%% Exercise "Analyzing Music in the Time and Frequency Domain using MATLAB"
%
% by Martin H. Trauth, 8 Juli 2020
% http://mres.uni-potsdam.de

%%
clear, close all, clc

%%
x5 = audioread('exercise_music_spectrum_data.wav');
x5info = audioinfo('exercise_music_spectrum_data.wav');

sound(x5,48000)

figure('Position',[50 1000 800 300],...
    'Color',[1 1 1])
axes('XLim',[0 length(x5)/x5info.SampleRate])
line((1:length(x5))/x5info.SampleRate,x5)
xlabel('Time (s)')
ylabel('Amplitude')
title('Time Series')

print -dpng -r300 exercise_music_figure_1_vs1.png

%%
[Pxx5,f5] = periodogram(x5,[],length(x5),x5info.SampleRate);

figure('Position',[50 600 800 300],...
    'Color',[1 1 1])
axes('XLim',[0 2000])
line(f5,abs(Pxx5))
xlabel('Frequency')
ylabel('Power')
title('Auto-Spectrum')

print -dpng -r300 exercise_music_figure_2_vs1.png

%%
[sn5,fn5,tn5] = spectrogram(x5,10000,5000,1000,x5info.SampleRate);

figure('Position',[50 200 800 300],...
    'Color',[1 1 1])
pcolor(tn5,fn5,log(abs(sn5))), shading flat
set(gca,'YLim',[0 2000])
title('Evolutionary Power Spectrum')
ylabel('Frequency (Hz)')
xlabel('Time (s)')
caxis([-5 2])
c = colorbar;
c.Label.String = 'Power (dB)';

print -dpng -r300 exercise_music_figure_3_vs1.png



