clear, close all, clc

%%
I1 = imread('IMG_2666.jpeg');

%%
I1(:,:,1) = imadjust(I1(:,:,1));
I1(:,:,2) = imadjust(I1(:,:,2));
I1(:,:,3) = imadjust(I1(:,:,3));

%%
I2 = reshape(I1,[size(I1,1)*size(I1,2) size(I1,3)]);

%%
I2 = double(I2);

%%
[coeff,newdata,~,~,variance] = pca(I2);
clear I2
variance

%%
I3 = reshape(newdata,size(I1));
clear newdata coeff variance

%%
close all
figure('Position',[100 200 800 600])
axes('Position',[0.05 0.55 0.4 0.4])
imagesc(I1), title('RGB'), colorbar
axes('Position',[0.50 0.55 0.4 0.4])
imagesc(I3(:,:,1)), title('PC1'), colorbar
axes('Position',[0.05 0.10 0.4 0.4])
imagesc(I3(:,:,2)), title('PC2'), colorbar
axes('Position',[0.50 0.10 0.4 0.4])
imagesc(I3(:,:,3)), title('PC3'), colorbar

print -dpng -r300 Exercises_Multispectral_Office_2020_iPhone_1_vs1.png

%%
close all
figure('Position',[100 1000 800 600])
axes('Position',[0.05 0.55 0.4 0.4])
imagesc(I1(800:1200,1000:1500,:)), title('RGB'), colorbar
axes('Position',[0.50 0.55 0.4 0.4])
imagesc(I3(800:1200,1000:1500,1)), title('PC1'), colorbar
axes('Position',[0.05 0.10 0.4 0.4])
imagesc(I3(800:1200,1000:1500,2)), title('PC2'), colorbar
axes('Position',[0.50 0.10 0.4 0.4])
imagesc(I3(800:1200,1000:1500,3)), title('PC3'), colorbar

print -dpng -r300 Exercises_Multispectral_Office_2020_iPhone_2_vs1.png

%%
% Thresholds
I3T(:,:,1) = imbinarize(I3(:,:,1),-50);
I3T(:,:,2) = imbinarize(I3(:,:,2),5);
I3T(:,:,3) = imbinarize(I3(:,:,1),50);

% Counting pixels
I4_M = zeros(size(I3T(:,:,1)));
I4_M(I3T(:,:,1)==0) = 1;
I4_K = zeros(size(I3T(:,:,1)));
I4_K(I3T(:,:,2)==1) = 1;
I4_P = zeros(size(I3T(:,:,1)));
I4_P(I3T(:,:,3)==1 & I3T(:,:,2)==0) = 1;
I4_Q = zeros(size(I3T(:,:,1)));
I4_Q(I3T(:,:,1)==1 & I4_K==0 & I4_P==0) = 1;

% Merging pixel counts to one single variable
I4(:,:,1) = I4_M;
I4(:,:,2) = I4_K;
I4(:,:,3) = I4_P;
I4(:,:,4) = I4_Q;

%%
% Display
figure('Position',[100 100 800 600])
axes('Position',[0.05 0.55 0.4 0.4])
imagesc(I4(800:1200,1000:1500,1)), title('Biotite and Hornblende'), colorbar
axes('Position',[0.50 0.55 0.4 0.4])
imagesc(I4(800:1200,1000:1500,2)), title('Potassium Feldspar'), colorbar
axes('Position',[0.05 0.10 0.4 0.4])
imagesc(I4(800:1200,1000:1500,3)), title('Plagioclase'), colorbar
axes('Position',[0.50 0.10 0.4 0.4])
imagesc(I4(800:1200,1000:1500,4)), title('Quartz'), colorbar

print -dpng -r300 Exercises_Multispectral_Office_2020_iPhone_3_vs1.png

%%
% Count compounds
Total_Pixels = size(I1(:,:,1),1) * size(I1(:,:,1),2);
Total_M = 100*sum(sum(I4(:,:,1)==1))/Total_Pixels
Total_K = 100*sum(sum(I4(:,:,2)==1))/Total_Pixels
Total_P = 100*sum(sum(I4(:,:,3)==1))/Total_Pixels
Total_Q = 100*sum(sum(I4(:,:,4)==1))/Total_Pixels

%%
save Exercises_Multispectral_Office_2020_iPhone_vs1.mat



