%% Exercise "Exercise Smartphone Seismometer"
%
% by Martin H. Trauth, 15 February 2020
% http://mres.uni-potsdam.de

%%
clear, clc, close all

%%
data = readtable('exercise_7_4_1_data_1.csv');

%%
unixtime = table2array(data(:,1));
data.timestamp = datetime(unixtime,'ConvertFrom','posixtime');

%%
figure('Position',[50 600 800 400])
stackedplot(data,'XVariable','timestamp');
title('Seismometer App')

%%
print -dpng -r300 exercise_7_4_1_figure_1.png

%%
clear, clc

%%
datastruct = load('exercise_7_4_1_data_2.mat');

%%
datatable = datastruct.Acceleration;

%%
figure('Position',[50 100 800 400])
stackedplot(datatable);
title('MATLAB Mobile')

%%
print -dpng -r300 exercise_7_4_1_figure_2.png

%%
save exercise_7_4_1_data_3.mat











