%% Exercise "Controlling motors by sonic sensor"
%
% by Martin H. Trauth, 9 Dez 2017
% http://mres.uni-potsdam.de

clear, clc, close all

%%
mylego = legoev3('USB');

%%
clear time distance rotation_A
mysonicsensor = sonicSensor(mylego);
mymotor_A = motor(mylego,'A');
resetRotation(mymotor_A)
mymotor_A.Speed = -10

for i = 1 : 90
    start(mymotor_A)
    pause(0.20)
    stop(mymotor_A)
    rotation_A(i) = readRotation(mymotor_A);
    for j = 1 : 250
        distance(i,j) = readDistance(mysonicsensor);
    end
    disp(num2str(mean(distance(i,j),2)))
    pause(1)
end

%%
distancemean = (mean(distance'))';

%%
surf(distance),shading interp

%%
% Full trip distance based on the 17 mm diameter of the wheels. Rotation
% reading is not very precise and therefore we get a 5% error in the
% distance.
fulltrip = 2*pi*8.5 * max(abs(double(rotation_A)))/360 * 0.1

%%
trip = 0+fulltrip/length(distancemean):fulltrip/length(distancemean):fulltrip;
trip = trip';

%%
% Sampling interval (in cm)
sampleint = fulltrip/length(distancemean)

%%
% Standardize distance data to a total of 1
distancemean = -distancemean + 0.205;
distancemean = distancemean/sum(distancemean);
distancemean(distancemean<0) = 0;
distancemean = distancemean/sum(distancemean);

%%
% Magnitude response
[h,w] = freqz(distancemean,1,512);
f = (1/sampleint)*w/(2*pi);

%%
figure1 = figure('Position',[200 600 800 400],...
    'Color',[1 1 1]);
axes1 = axes('LineWidth',1,...
    'FontName','Helvetica',...
    'FontSize',12,...
    'XGrid','on',...
    'YGrid','on');
line1 = line(trip,distancemean,...
    'LineWidth',1);
xlabel1 = xlabel('Length (cm)',...
    'FontName','Helvetica',...
    'FontSize',12);
ylabel1 = ylabel('Distance (m)',...
    'FontName','Helvetica',...
    'FontSize',12);

print -dpng -r300 sonicsensor_impulsereponse.png

figure('Position',[200 400 800 400],...
    'Color',[1 1 1]);
axes('LineWidth',1,...
    'FontName','Helvetica',...
    'FontSize',12,...
    'XGrid','on',...
    'YGrid','on',...
    'XLim',[0 50]);
line(1./f,abs(h)/max(abs(h)),...
    'LineWidth',1);
xlabel('Period (cm)',...
    'FontName','Helvetica',...
    'FontSize',12);
ylabel('Magnitude',...
    'FontName','Helvetica',...
    'FontSize',12);

print -dpng -r300 sonicsensor_frequencyreponse_period.png

figure('Position',[200 200 800 400],...
    'Color',[1 1 1]);
axes('LineWidth',1,...
    'FontName','Helvetica',...
    'FontSize',12,...
    'XGrid','on',...
    'YGrid','on',...
    'XLim',[0 1]);
line(f,abs(h)/max(abs(h)),...
    'LineWidth',1);
xlabel('Frequency (1/cm)',...
    'FontName','Helvetica',...
    'FontSize',12);
ylabel('Magnitude',...
    'FontName','Helvetica',...
    'FontSize',12);

print -dpng -r300 sonicsensor_frequencyreponse_freq.png

%%
save Exercises_Spatial_resolution_of_sonic_sensor.mat


