%% Visualize the data
clear, close all, clc

%% Read the Coordinates from thingSpeak; Number of Points has to be specified (8000 is the maximum value)
lat = thingSpeakRead(898768,'Fields',[1],'ReadKey','JDH3C7NXD5Z8VMWF','NumPoints', 8000);
lon = thingSpeakRead(898768,'Fields',[2],'ReadKey','JDH3C7NXD5Z8VMWF','NumPoints', 8000);
alt = thingSpeakRead(898768,'Fields',[3],'ReadKey','JDH3C7NXD5Z8VMWF','NumPoints', 8000);

% Retrieve logged position data and create geographical shape vector s
lat = lat';
lon = lon';
alt = alt';

s = geoshape();
s(1) = [lat;lon];

%%
% Display the data
figure('Position',[100 500 1200 400])
subplot(1,3,1), histogram(lon), title('Longitude')
subplot(1,3,2), histogram(lat), title('Latitude')
subplot(1,3,3), histogram(alt), title('Altitude (m)')

%%
% Create a web map, draw a line and zoom the map
wm = webmap('Open Street Map');
wmline(s, 'Width', 5);
wmzoom(16);
