%% Remove jumps from time series
% M.H. Trauth 25 Jan 2018

%% Create synthetic data with jumps
clear, clc, close all
t = 0 : 0.1 : 10*pi;

% Two possible synthetic data
x1 = sin(t);
%x1 = randn(size(t));

% Add jumps
x1(1,131:315) = x1(1,131:315) +  5;
x1(1,170:315) = x1(1,170:315) - 10;

%% Option 1 Remove outliers from 1st derivative, then integrate
% Calculate 1st derivative
x2 = diff(x1);

% Remove outliers in 1st derivative, losing one data point at the end
x3 = filloutliers(x2,'pchip');

% Integrate and add NaN at the end of the time series
x4 = cumsum(x3);
x4(end+1) = NaN;

% Display results
figure('Position',[100 100 800 1000])
axes('Position',[0.1 0.8 0.8 0.15])
plot(t,x1), grid, title('Original Data with Jumps')
axes('Position',[0.1 0.6 0.8 0.15])
plot(t(1:end-1),x2), grid, title('1st Derivative')
axes('Position',[0.1 0.4 0.8 0.15])
plot(t(1:end-1),x3), grid, title('1st Derivative, Outliers removed')
axes('Position',[0.1 0.2 0.8 0.15])
plot(t,x1,t,x4), grid, title('Integrated Signal')

print -dpng -r150 jumps_1a_vs1.png

%% Option 2 Use FINDCHANGEPTS to detect abrupt changes in the mean
clear x2 x3 x4

% Find change points in the mean
maxnumchg = 2;
[ipoint,residual] = findchangepts(x1,'MaxNumChanges',maxnumchg);
m(1) = mean(x1(1:ipoint(1)));
for i = 1 : length(ipoint)-1
    m(i+1) = mean(x1(ipoint(i):ipoint(i+1)));
end
m(length(ipoint)+1) = mean(x1(ipoint(i+1):end));

% Remove mean of sections between change points
x2 = zeros(size(x1));
x2(1:ipoint(1)) = x1(1:ipoint(1)) - m(1);
for i = 1 : length(ipoint)-1
    x2(ipoint(i):ipoint(i+1)) = x1(ipoint(i):ipoint(i+1)) - m(2);
end
x2(ipoint(i+1):end) = x1(ipoint(i+1):end) - m(end);

% Display results
figure('Position',[100 100 800 1000])
axes('Position',[0.1 0.8 0.8 0.15])
plot(t,x1), grid, title('Original Data with Jumps')
axes('Position',[0.1 0.6 0.8 0.15],...
     'XLim',[0 35],'Box','On'), hold on
line(t,x1)
line([0 t(ipoint(1))],[m(1) m(1)])
for i = 1 : length(ipoint)-1
    line([t(ipoint(i)) t(ipoint(i+1))],[m(i+1) m(i+1)])
end
line([t(ipoint(length(ipoint))) t(end)],[m(end) m(end)])
stem(t(ipoint),6*ones(size(t(ipoint))),...
    'Marker','none',...
    'Color',[0.4667 0.6745 0.1882],...
    'BaseValue',-6)
title('Original Data with Change Points in the Mean')
axes('Position',[0.1 0.4 0.8 0.15])
plot(t,x1,t,x2)
title('Data without Jumps')

print -dpng -r150 jumps_1b_vs1.png







