%% Acquire GPS Data
% Connect to mobile device and create object
clear, clc, close all
connector on mypassword;
m = mobiledev

%%
% Prepare for data acquisition from the position sensor
m.PositionSensorEnabled = 1;

%%
% Logging, GPS sensor has a relatively low sampling rate of 0.2 Hz?
m.Logging = 1;

%%
% Stop logging
m.Logging = 0;
   
%%
% Retrieve logged position data and create geographical shape vector s
[lat, lon] = poslog(m);
lat = lat';
lon = lon';
s = geoshape();
s(1) = [lat;lon];

%%
% Create a web map, draw a line and zoom the map
wm = webmap('Open Street Map');
wmline(s, 'Width', 5);
wmzoom(16);


