%% Exercise "Exercise_Precession_Aaccuracy_of_sensor"
%
% by Martin H. Trauth, 21 November 2019
% http://mres.uni-potsdam.de

%%
% First clear the workspace, the command window and close all figures
clear, clc, close all

%%
% We use a USBconnection to connect the EV3 brick with the PC.
mylego = legoev3('USB');

%%
% Create an object to connect to the ultrasonic/ir sensor
mysonicsensor = sonicSensor(mylego);

%%
% Read distance from ultrasonic/ir sensor
clear distance
tic
for i = 1 : 1000
    distance_so(i) = readDistance(mysonicsensor);
end
dur = toc;

%%
% Calculate the time of measurements
time_so = dur/length(distance_so) : dur/length(distance_so) : dur;

%%
% Determine the unique values in distance_so
unique(distance_so)

%%
% Plotting the time series of distance measurements of sonic sensor
close all
figure1 = figure('Position',[100 700 800 400],...
    'Color',[1 1 1]);
axes1 = axes('LineWidth',1,...
    'FontName','Helvetica',...
    'FontSize',12,...
    'XGrid','on',...
    'YGrid','on');
line1 = line(time_so,distance_so,...
    'LineWidth',1);
xlabel1 = xlabel('Time (s)',...
    'FontName','Helvetica',...
    'FontSize',12);
ylabel1 = ylabel('Distance (m)',...
    'FontName','Helvetica',...
    'FontSize',12);
title('Sonic Sensor',...
    'FontName','Helvetica',...
    'FontSize',12);
print -dpng -r300 Exercise_Precision_Accuracy_of_sensor_3_1.png

% Plotting the histogram of distance measurements of sonic sensor
figure1 = figure('Position',[100 200 800 400],...
    'Color',[1 1 1]);
axes1 = axes('LineWidth',1,...
    'FontName','Helvetica',...
    'FontSize',12,...
    'XGrid','on',...
    'YGrid','on'); hold on
histogram(distance_so)
ylabel1 = ylabel('Distance (m)',...
    'FontName','Helvetica',...
    'FontSize',12);
ylabel1 = ylabel('Frequency',...
    'FontName','Helvetica',...
    'FontSize',12);
title('Sonic Sensor',...
    'FontName','Helvetica',...
    'FontSize',12);
set(axes1,'YScale','Log')
print -dpng -r300 Exercise_Precision_Accuracy_of_sensor_3_2.png

%%
save Exercise_Precision_Accuracy_of_sensor_3.mat distance* dur t*




