function c = precip(m)
%PRECIP Shades of blue and yellow color map.
%   PRECIP(M) returns an M-by-3 matrix containing a "precip" colormap.
%   PRECIP, by itself, is the same length as the current colormap.
%
%   For example, to reset the colormap of the current figure:
%
%       colormap(precip)
%
%   See also HSV, GRAY, HOT, BONE, COPPER, PINK, FLAG, 
%   COLORMAP, RGBPLOT, WINTER

if nargin < 1, m = size(get(gcf,'colormap'),1); end
r = (0:m-1)'/max(m-1,1); 
c = [r 0.9.*r .5+(1-r)/2];
