%--------------------------------------------------------------------------
% Lake Balance Model
% 
% by Bodo Bookhagen, Kirk Haselton and Martin Trauth
%
% Please cite
%
% Bookhagen, B., Haselton, K.R., Trauth, M.H. (2001) Hydrological modelling
% of a Pleistocene landslide-dammed lake in the Santa Maria Basin, NW
% Argentina. Palaeogeography Palaeoclimatology Palaeoecology, 169, 113-127.
%
% Lenters, J.D., Cook, K.H. (1999) Summertime precipitation variability over
% South America: role of the large-scale circulation. Monthly Weather Review
% 127, 409-431.
%
% Modified by Martin Trauth August 2007
%--------------------------------------------------------------------------

global t_s_ld t_s_lk
global e_ld e_lk

cd land

constantsland

evaland

disp(' ')
initial_string = sprintf('T_a_ld (calc)           =   %4.2f',t_a_ld);
disp(initial_string);
initial_string = sprintf('T_s_ld (calc)           =   %4.2f',t_s_ld);
disp(initial_string);
initial_string = sprintf('E_ld   (calc)           =   %4.2f',e_ld);
disp(initial_string);
disp(' ')

cd ..
cd lake

clear a a_2 albedo_ld b b_2 cc cds cp emis_ld f_ld h initial_string
clear l mmyr p r r_ldw r_lup r_sw r_swc rh sigma ws  

constantslake

evalake

disp(' ')
initial_string = sprintf('T_a_lk (calc)           =   %4.2f',t_a_lk);
disp(initial_string);
initial_string = sprintf('T_s_lk (calc)           =   %4.2f',t_s_lk);
disp(initial_string);
initial_string = sprintf('E_lk   (calc)           =   %4.2f',e_lk);
disp(initial_string);
disp(' ')

cd ..

clear a a_2 albedo_lk b b_2 cc cds cp emis_lk f_lk h initial_string
clear l mmyr p r r_ldw r_lup r_sw r_swc rh sigma ws  
