function [P1] = findroot(f, x0)

% Find zero of function of one variable using Newton's Method
% modified by Bodo Bookhagen and Martin Trauth 2001

% Similar to Matlab function fzero.m

% findroot (f,x0) tries to find a zero of F.  F is a string containing 
% the name of a real-valued function of a single real variable.   
% The value returned is near a point where F changes sign, or NaN 
% if the search fails.  

% Examples
% x=findroot('sin', 4) returns pi
% x=findroot('testfun',-2) returns -2.3028 for fx=x.^2 +x -3;

  Maxn = 20;                          % Maximum number of terms
  ROOT_DELTA_TOLERANCE = 1E-6;        % Tolerance used for root finding
  ROOT_EPSILON_TOLERANCE = 1E-6;
  ROOT_SMALL_TOLERANCE = 1E-6;
  ROOT_ITERATIONS = 9999;

  Delta = ROOT_DELTA_TOLERANCE;       % Tolerance   
  Epsilon = ROOT_EPSILON_TOLERANCE;   % Tolerance   
  Small = ROOT_SMALL_TOLERANCE;       % Tolerance   

  Max = ROOT_ITERATIONS;              % Maximum number of iterations   
  Cond = -1;                          % Condition for loop termination  

  P0 = x0; 
  Y0 = dffunction(f, P0);
  
  for K = 1:Max  
    if Cond >= 0
      break; 
    end   
    Df = dffunction(f, P0);           % Compute the derivative      
    if Df == 0                        % Check division by zero  
      Cond = 1;
      Dp   = 0;
    else Dp = Y0/Df;
    end   
    P1 = P0 - Dp;                     % New iteratation  
    Y1 = feval(f,P1);                 % New function value   
    RelErr = 2 * abs(Dp) / ( abs(P1) + Small );    % Relative error	 
    if( (RelErr < Delta)  & (abs(Y1) < Epsilon) )  % Check for convergence  
      if( Cond ~= 1) Cond = 2; end                 % Convergence
    end   
    P0 = P1;
    Y0 = Y1;
  end
  if Cond == 0
    disp('The maximum number of iterations was exceeded !');
  end
  if Cond == 1
    disp('Division by zero was encountered !');
  end
