function D_out = dffunction(f, x)

% Routine calculates derivation of a Function  
% modified by Bodo Bookhagen and Martin Trauth 2001

% Input: dffunction(f, x): 
% f: function, x: start-value
  
  CONVERGANCE_TOLERANCE = 1E-5; % Tolerance of derivative function
  Tol = CONVERGANCE_TOLERANCE;
  Maxn = 20;
  
  H = 1.0;               % Initial Step size               
  
  Danger = 1E+100;       % Border for errors               
    
  X = x;

  % Compute the quotient  
  
  D(1) = 0.5 * ( feval(f,(X + H)) - feval(f,(X - H)) ) / H;
  
  % Computer D_1 and D_2  
  
  for N = 2:5
    H = H / 2.0;         % Reduce step size  
    
    % Compute the quotient  
    
    D(N) = 0.5 * ( feval(f,(X + H)) - feval(f,(X - H)) ) / H;
    
    % Error estimate and relative error  
    
    E(N) = abs( D(N) - D(N-1) );    
    RE(N) = 2.0 * E(N) / ( abs( D(N) ) + abs( D(N-1) ) + Tol );
  
  end
  
  N = 1;   			% Initialize counter  
  
  while ( (E(N) > E(N+1)) || (RE(N) >= Tol) ) && (N < Maxn)
    H = H / 2.0;    % Reduce step size  
    
    % Compute the quotient  
    
    D(N+2) = 0.5 * ( feval(f,(X + H)) - feval(f,(X - H)) ) / H;
    
    % Error estimate and relative error  
    
    E(N+2) = abs( D(N+2) - D(N+1) );
    RE(N+2) = 2.0 * E(N+2) / ( abs(D(N+2)) + abs(D(N+1)) + Tol );
    
    % check if Error or RelErr grow and prevent floating point exception  
    
    if ( E(N+2) > Danger || RE(N+2) > Danger)
      disp('Error and/or Relative Error grow(s) too big !');
    end
    
    N = N + 1;   % Increment the counter  
  end

  if N > 1 
    disp(D(N-1));
    D_out = D(N-1);
  else 
    D_out = D(N);
  end
  
  
  
