%--------------------------------------------------------------------------
% NEW LAKE BALANCE MODEL BY MARTIN TRAUTH, AUGUST 2007
%--------------------------------------------------------------------------

global t_a_ld     % Air Temperature in [K] modern conditions mean
global emis_ld    % Surface emissivity
global l          % Latent heat of vaporization
global r_swc      % Cloud-free r_sw
global albedo_ld  % Albedo over land
global sigma      % Stefan Boltzmann constant
global rh         % Relative humidity
global f_ld       % Moisture availability function over land
global cc         % Cloud cover
global a          % Short wave cloud parameters
global b          % Short wave cloud parameters
global a_2        % Long wave cloud parameters
global b_2        % Long wave cloud parameters
global ws         % Wind speed 
global cds        % Surface drag coefficient
global cp         % Specific heat of dry air 
global p          % Air pressure 
global r          % Gas constant for dry air 
global mmyr       % Converts evaporation rate from [kg m-^2 s^-1] to
		  		  % [mm yr^-1]

%--------------------------------------------------------------------------
% VARIABLES AND CONSTANTS (CALC = WILL BE COMPUTED BY THE ALGORITHM)
%--------------------------------------------------------------------------

%t_s_ld   = CALC      % Temperature on land surface
t_a_ld    = 297.45;   % Air Temperature in [K] modern conditions mean (1)
                      % Average 24.3 deg C from gridded values
%r_sw     = CALC      % Net short wave radiation down  
%r_lup    = CALC      % Net long wave radiation up
%r_ldw    = CALC      % Net long wave radiation down
emis_ld   = 0.92;     % Surface emissivity
%h        = CALC      % Sensible heat rate
l         = 2.45E6;   % Latent heat of vaporization in [J kg-1] (4) (FIX)
r_swc     = 415;      % Cloud-free r_sw (6,7)
albedo_ld = 0.22;     % Albedo over land (1)
sigma     = 5.67E-8;  % Stefan Boltzmann constant in [kg s-3 K-4] (FIX)
rh        = 0.57;     % Relative humidity in [%/100] (1)
f_ld      = 0.1;      % Moisture availability function over land (8)
%es       = CALC      % Saturation vapour pressure
cc        = 0.45;     % Cloud cover in [%/100] (2)
a         = 0.39;     % Short wave cloud parameters
b         = 0.38;     % Short wave cloud parameters
a_2       = 0.22;     % Long wave cloud parameters
b_2       = 2.00;     % Long wave cloud parameters
ws        = 3.2;      % Wind speed in 10 m above ground (3.2+/-0.1 m/s) (1)
cds       = 1.1E-3;   % Surface drag coefficient (9)
cp        = 1005.0;   % Specific heat capacity of dry air [kJ/kg K] (FIX)
p         = 8.49E4;   % Air pressure in [Pa] (5)
r         = 287.0;    % Gas constant for dry air in [J/K kg] (FIX)
mmyr      = 3.1536E7; % Converts evaporation rate from [kg m-^2 s^-1] to
		      		  % [mm yr^-1] (FIX)


%--------------------------------------------------------------------------
% References
%--------------------------------------------------------------------------

% (1) New, M., Lister, D., Hulme, M., Makin, I., 2000, Climate Research,
%	  21, 1-25.
% (2) Hastenrath, S., Kutzbach, J.E., 1983, Quaternary Research, 19, 141-
%     153. Values for Turkana in comparison with Victoria, Naivasha and
%     Nakuru-Elmenteita
% (3) http://www.engineeringtoolbox.com/air-properties-d_156.html
% (4) As l varies only slightly over normal temperature ranges a single
%     value of 2.45 MJ kg-1 is taken for the simplification. This is the
%     latent heat for an air temperature of about 20C.
% (5) http://wetter.andreae-gymnasium.de/interaktives/Druck
%     /barometrische.htm
%     Altitude Lake m  Temperature C  Air pressure hPa
%     575              25            949.0
%     2700             20            749.7
% (6) Brigg, 1990, siehe Bergner Diplomarbeit, Seite 61
% (7) Griffiths, 1972, siehe Bergner Diplomarbeit, Seite 61
% (8) siehe Tabelle Bergner Diplomarbeit, Seite 58
% (9) Schmugge and Andre, Seite 9-10


















