%% Lego Mindstorms Experiment 5
clear, clc, close all
 
%% Getting started: Setup
% Use Wifi connection
%mylego = legoev3('WiFi','10.0.1.3','00165350bf24');
mylego = legoev3('USB');
connector on
m = mobiledev;
 
%%
mymotor_A = motor(mylego,'A');
mymotor_B = motor(mylego,'B');
mymotor_C = motor(mylego,'C');
mymotor_D = motor(mylego,'D');
mytouchsensor = touchSensor(mylego);
m.MagneticSensor = 1;
 
%%
mm = 40;
nn = 30;
magij = zeros(mm,nn,3);
for j = 1 : mm
clear magi
dispi = ['Step = ',num2str(j)];
disp(dispi)
mymotor_A.Speed = 25;
mymotor_B.Speed = 25;
mymotor_C.Speed = 25;
%
pause(0.5)
mymotor_D.Speed = -20;
for i = 1 : nn
    clear mag tm
    % Discard all logged data before moving to new position
    discardlogs(m)
    start(mymotor_D)
    pause(0.1)
    stop(mymotor_D)
    % Beginning and end magnetometer measurements
    m.Logging = 1;
    pause(1)
    m.Logging = 0;
    % Extract and average data from m
    [mag, tm] = magfieldlog(m);
    magi(i,:) = mean(mag);
    % End magnetometer
end
magij(j,:,:) = magi;     
mymotor_D.Speed = 20;
pressed = readTouch(mytouchsensor);
while pressed == 0
    pressed = readTouch(mytouchsensor);
    start(mymotor_D)
end
stop(mymotor_D)
%
start(mymotor_A)
start(mymotor_B)
start(mymotor_C)
pause(0.3)
stop(mymotor_A)
stop(mymotor_B)
stop(mymotor_C)
end
 
%%
stop(mymotor_A)
stop(mymotor_B)
stop(mymotor_C)
stop(mymotor_D)
 
%%
total = sqrt(magij(:,:,1).^2+magij(:,:,2).^2+magij(:,:,3).^2);
 
%%
figure('Position',[100 800 1200 400])
subplot(1,3,1), imagesc(magij(:,:,1)), title('X')
subplot(1,3,2), imagesc(magij(:,:,2)), title('Y')
subplot(1,3,3), imagesc(magij(:,:,3)), title('Z')

%%
% Eliminate jumps in X
imagesc(magij(:,:,1))
X = magij(:,:,1);
X(18,15) = X(18,15) - 1;
X(19,15) = X(19,15) - 5;
X(19,15:30) = X(19,15:30) + 30;
X(20, 1:30) = X(20, 1:30) + 30;
X(21, 1:30) = X(21, 1:30) + 30;
X(22, 1: 6) = X(22, 1: 6) + 28;
X(22,    7) = X(22,    7) + 18;
X(22,18) = X(22,18) - 5;
X(22,19) = X(22,19) - 5;
X(33,29:30) = X(33,29:30) + 10;
X(34:40, 1:30) = X(34:40, 1:30) + 10;
figure, imagesc(X)
figure('Position',[100 800 1200 800]), surf(X)

%%
% Eliminate jumps in Y
imagesc(magij(:,:,2))
Y = magij(:,:,2);
Y(1:23,:) = Y(1:23,:) + 18;
Y(19,15:30) = Y(19,15:30) + 10;
Y(20, 1:30) = Y(20, 1:30) + 10;
Y(21, 1:30) = Y(21, 1:30) + 10;
Y(22, 1: 6) = Y(22, 1: 6) + 10;
Y(22,    7) = Y(22,    7) + 10;
Y(24,  : ) = Y(24,  : ) + 13;
Y(25, 1:8) = Y(25, 1:8) + 10;
Y(33,29:30) = Y(33,29:30) + 20;
Y(34:40, 1:30) = Y(34:40, 1:30) + 20;
figure, imagesc(Y)
figure('Position',[100 800 1200 800]), surf(Y)

%%
% Eliminate jumps in Z
close all
imagesc(magij(:,:,3))
Z = magij(:,:,3);
Z(1:18,:) = Z(1:18,:) - 30;
Z(19,1:14) = Z(19,1:14) - 32;
Z(19,15) = Z(19,15) - 7;
Z(20,1:14) = Z(20,1:14) - 3;
Z(20,15:30) = Z(20,15:30) - 5;
Z(21, :) = Z(21, :) - 10;
Z(22, 1: 6) = Z(22, 1: 6) - 15;
Z(22, 7) = Z(22, 7) - 7;
Z(33,29:30) = Z(33,29:30) - 45;
Z(34:40, 1:30) = Z(34:40, 1:30) - 45;
figure, imagesc(Z)
figure('Position',[100 800 1200 800]), surf(Z)

%%
figure('Position',[100 800 1200 400])
subplot(1,3,1), imagesc(magij(:,:,1)), title('X')
subplot(1,3,2), imagesc(magij(:,:,2)), title('Y')
subplot(1,3,3), imagesc(magij(:,:,3)), title('Z')

figure('Position',[100 800 1200 400])
subplot(1,3,1), imagesc(X), title('X')
subplot(1,3,2), imagesc(Y), title('Y')
subplot(1,3,3), imagesc(Z), title('Z')

%%
save Exercise_2D_Scanner_iPhone_Magnetic_Sensor_MATLAB_7.mat

%%
load Exercise_2D_Scanner_iPhone_Magnetic_Sensor_MATLAB_7.mat

%%
% Referencing
x = 0 : 20/30 : 20;
y = 0 : 53/40 : 53;

%%
figure('Position',[100 800 1200 400])
subplot(1,3,1), imagesc(x,y,magij(:,:,1)), axis image, title('X'), xlabel('cm'), ylabel('cm')
subplot(1,3,2), imagesc(x,y,magij(:,:,2)), axis image, title('Y'), xlabel('cm'), ylabel('cm')
subplot(1,3,3), imagesc(x,y,magij(:,:,3)), axis image, title('Z'), xlabel('cm'), ylabel('cm')

figure('Position',[100 800 1200 400])
subplot(1,3,1), imagesc(x,y,X), axis image, title('X'), xlabel('cm'), ylabel('cm')
subplot(1,3,2), imagesc(x,y,Y), axis image, title('Y'), xlabel('cm'), ylabel('cm')
subplot(1,3,3), imagesc(x,y,Z), axis image, title('Z'), xlabel('cm'), ylabel('cm')

%%
close all
figure('Position',[100 800 800 400])
subplot(1,3,1), imagesc(x,y,magij(:,:,1)), axis image,
title('X'), xlabel('cm'), ylabel('cm'), caxis([-60 50])
c= colorbar; c.Label.String = 'Magnetic Flux Density (T)';
subplot(1,3,2), imagesc(x,y,magij(:,:,2)), axis image,
title('Y'), xlabel('cm'), ylabel('cm'), caxis([-60 50])
c= colorbar; c.Label.String = 'Magnetic Flux Density (T)';
subplot(1,3,3), imagesc(x,y,magij(:,:,3)), axis image,
title('Z'), xlabel('cm'), ylabel('cm'), caxis([-60 50])
c= colorbar; c.Label.String = 'Magnetic Flux Density (T)';

print -dpng -r300 magnetic_results_raw_vs3.png

figure('Position',[100 800 900 400])
subplot(1,3,1), imagesc(x,y,X), axis image, title('X')
c= colorbar; c.Label.String = 'Magnetic Flux Density (T)';
xlabel('cm'), ylabel('cm'), caxis([-60 50])
subplot(1,3,2), imagesc(x,y,Y), axis image, title('Y')
c= colorbar; c.Label.String = 'Magnetic Flux Density (T)';
xlabel('cm'), ylabel('cm'), caxis([-60 50])
subplot(1,3,3), imagesc(x,y,Z), axis image, title('Z')
xlabel('cm'), ylabel('cm'), caxis([-60 50])
c= colorbar; c.Label.String = 'Magnetic Flux Density (T)';

print -dpng -r300 magnetic_results_edit_vs3.png












 
