%% MATLAB and Design Recipes for Earth Sciences - Chapter 6

%% Section 6.2
clear, clc, close all

%%
unzip('gshhg-bin-2.3.6.zip')

%%
S = gshhs('gshhs_h.b');

%%
data(:,1) = S(2).Lon;
data(:,2) = S(2).Lat;

%%
save coastline_data.txt data -ascii

%%
data = load('coastline_data.txt');

%%
figure1 = figure('Color',[1 1 1]);
axes1 = axes('Box','on',...
    'DataAspectRatio',[1 1 1]);
line1 = line(data(:,1),data(:,2),...
    'Color',[0 0 0]);
xlabel1 = xlabel('Longitude');
ylabel1 = ylabel('Latitude');

%%
figure1 = figure('Color',[1 1 1]);
axes1 = axesm('MapProjection','mercator', ...
      'MapLatLimit',[-40 40], ...
      'MapLonLimit',[-20 60], ...
      'Frame','on', ...
      'MeridianLabel','on', ...
      'ParallelLabel','on',...
      'Grid','on');
axes1.Visible = 'off';
line1 = linem(data(:,2),data(:,1),'k');

%%
figure1 = figure('Color',[1 1 1]);
worldmap1 = worldmap('africa');
geoshow1 = geoshow(data(:,2),data(:,1),...
    'Color',[0 0 0]);

%%
figure1 = figure('Color',[1 1 1]);
axes1 = axes('Units','Centimeters',...
    'Position',[3 2 10 8],...
    'Box','on',...
    'LineWidth',0.6,...
    'FontSize',8);
line1 = line(data(:,1),data(:,2),...
    'Color',[0.1 0.3 0.8],...
    'LineWidth',0.5);
title1 = title('GSHHS Shoreline Data Set',...
    'FontSize',10);
xlabel1 = xlabel('Longitude',...
    'FontSize',8);
ylabel1 = ylabel('Latitude',...
    'FontSize',8);

%%
data = data(1:2:end,:);

%%
newdata = circshift(data,-1);
data(isnan(newdata)==1) = NaN;
data = data(1:2:end,:);

%%
figure1 = figure('Color',[1 1 1]);
axes1 = axes('Units','Centimeters',...
    'Position',[3 2 10 8],...
    'Box','on',...
    'LineWidth',0.6,...
    'FontSize',8);
line1 = line(data(:,1),data(:,2),...
    'Color',[0.1 0.3 0.8],...
    'LineWidth',0.5);
title1 = title('GSHHS Shoreline Data Set',...
    'FontSize',10);
xlabel1 = xlabel('Longitude',...
    'FontSize',8);
ylabel1 = ylabel('Latitude',...
    'FontSize',8);

%%
print -depsc2 coastline_linegraph_vs1_matlab.eps

