%% Exercise "Controlling motors by ir sensor"
clear, clc, close all

%%
mylego = legoev3('USB');

%%
clear time distance rotation_A
myirsensor = irSensor(mylego);
mymotor_A = motor(mylego,'A');
resetRotation(mymotor_A)
mymotor_A.Speed = -10

for i = 1 : 90
    start(mymotor_A)
    pause(0.20)
    stop(mymotor_A)
    rotation_A(i) = readRotation(mymotor_A);
    for j = 1 : 250
        distance(i,j) = readProximity(myirsensor);
    end
    disp(num2str(mean(distance(i,j),2)))
    pause(1)
end

%%
distancemean = (mean(distance'))';

%%
surf(distance),shading interp

%%
% Full trip distance based on the 17 mm diameter of the wheels. Rotation
% reading is not very precise and therefore we get a 5% error in the
% distance.
fulltrip = 2*pi*8.5 * max(abs(double(rotation_A)))/360 * 0.1

%%
trip = 0+fulltrip/length(distancemean):fulltrip/length(distancemean): fulltrip;
trip = trip';

%%
% Sampling interval (in cm)
sampleint = fulltrip/length(distancemean)

%%
% Magnitude response
[h,w] = freqz(distancemean,1,512);
f = (1/sampleint)*w/(2*pi);

%%
figure1 = figure('Position',[200 600 800 400],...
    'Color',[1 1 1]);
axes1 = axes('LineWidth',1,...
    'FontName','Helvetica',...
    'FontSize',12,...
    'XGrid','on',...
    'YGrid','on');
line1 = line(trip,distancemean,...
    'LineWidth',1);
xlabel1 = xlabel('Length (cm)',...
    'FontName','Helvetica',...
    'FontSize',12);
ylabel1 = ylabel('Distance (m)',...
    'FontName','Helvetica',...
    'FontSize',12);

print -dpng -r300 irsensor_impulsereponse.png

figure1 = figure('Position',[200 400 800 400],...
    'Color',[1 1 1]);
axes1 = axes('LineWidth',1,...
    'FontName','Helvetica',...
    'FontSize',12,...
    'XGrid','on',...
    'YGrid','on',...
    'XLim',[0 50]);
line1 = line(1./f,abs(h)/max(abs(h)),...
    'LineWidth',1);
xlabel1 = xlabel('Period (cm)',...
    'FontName','Helvetica',...
    'FontSize',12);
ylabel1 = ylabel('Magnitude',...
    'FontName','Helvetica',...
    'FontSize',12);

print -dpng -r300 irsensor_frequencyreponse_period.png

figure1 = figure('Position',[200 200 800 400],...
    'Color',[1 1 1]);
axes1 = axes('LineWidth',1,...
    'FontName','Helvetica',...
    'FontSize',12,...
    'XGrid','on',...
    'YGrid','on',...
    'XLim',[0 1]);
line1 = line(f,abs(h)/max(abs(h)),...
    'LineWidth',1);
xlabel1 = xlabel('Frequency (1/cm)',...
    'FontName','Helvetica',...
    'FontSize',12);
ylabel1 = ylabel('Magnitude',...
    'FontName','Helvetica',...
    'FontSize',12);

print -dpng -r300 irsensor_frequencyreponse_freq.png

%%
ir_trip = trip;
ir_distancemean = distancemean;
ir_f = f;
ir_h = h;

save irsensor.mat ir_trip ir_distancemean ir_f ir_h



