%% Exercise "Object scanning using ultrasonic sensor"
%
% by Martin H. Trauth, 15 March 2017
% http://mres.uni-potsdam.de

clear, clc, close all

%% Getting started: Setup
% Use Wifi connection
%mylego = legoev3('WiFi','10.0.1.2','00165350bf24');
mylego = legoev3('USB');

%%
mymotor_A = motor(mylego,'A');
mymotor_B = motor(mylego,'B');
mymotor_D = motor(mylego,'D');
mysonicsensor = sonicSensor(mylego);
mytouchsensor = touchSensor(mylego);

%%
clear distance
pause(3)

for j = 1 : 40
dispi = ['Step = ',num2str(j)];
disp(dispi)
mymotor_A.Speed = 50;
mymotor_B.Speed = 50;
%
pause(0.5)
mymotor_D.Speed = -20;
for i = 1 : 70
    start(mymotor_D)
    pause(0.125)
    stop(mymotor_D)
    for k = 1 : 50
        rawdistance(i,j,k) = readDistance(mysonicsensor);
    end
    distance(i,j) = mean(rawdistance(i,j,:));
    pause(0.25)
end

mymotor_D.Speed = +20;
start(mymotor_D)
pressed = readTouch(mytouchsensor);
while pressed == 0
    pressed = readTouch(mytouchsensor);
    start(mymotor_D)
end
stop(mymotor_D)
%
start(mymotor_A)
start(mymotor_B)
pause(0.1)
stop(mymotor_A)
stop(mymotor_B)
end

%%
stop(mymotor_A)
stop(mymotor_B)
stop(mymotor_D)

%%
close all
dt = datestr(now);
filename = ['distance',dt,'.mat'];
%save(filename,'distance')

x = 44/40 : 44/40 : 44; x = 10*x;
y = 27/70 : 27/70 : 27; y = 10*y;
[X,Y] = meshgrid(x,y);

%
figure('Position',[100 100 1200 400])
surf(X,Y,distance)
caxis([.14 0.26])
xlabel('X-axis (mm)'),ylabel('Y-axis (mm)'),
zlabel('Distance (m)')
view(40,40)

print -dpng -r300 Exercise_Object_scanning_ultrasonic_sensor_1.png

%
figure('Position',[100 600 1200 400])
surf(X,Y,distance)
caxis([.14 0.26])
xlabel('X-axis (mm)'),ylabel('Y-axis (mm)'),
zlabel('Distance (m)')
axis image
colorbar
view(0,90)

print -dpng -r300 Exercise_Object_scanning_ultrasonic_sensor_2.png






