%% Exercise "Controlling motors by sonic sensor"
%
% by Martin H. Trauth, 6 March 2017
% http://mres.uni-potsdam.de

%%
% First clear the workspace, the command window and close all figures
clear, clc, close all

%%
% We use a WiFi connection to connect the EV3 brick with the PC. Assume
% that the IP address of the EV3 brick is 10.0.1.3 and the serial number is
% 00165350bf24.
% mylego = legoev3('WiFi','10.0.1.3','00165350bf24');
mylego = legoev3('USB');

%%
% Creating a connection to the motors A and D, attached to the EV3 output
% ports A and D, and the sonic sensor, attached to the EV3 input port 1.
% The input ports are automatically detected by MATLAB. Connecting the LEGO
% devices the object handles mymotor_A, mymotor_D and mysonicsensor for
% these connections is returned, which will later be used to control the
% motors and to read the sensor.
mymotor_A = motor(mylego,'A')
mymotor_D = motor(mylego,'D')
mysonicsensor = sonicSensor(mylego)

%%
% Then we reset the motors and define a speed of 50% for the motors. Using
% a while statement the motors are running until the distance of the sensor
% from a obstacle is less than 0.3 meters, then move back with -50% speed
% for 5 seconds. We can record the distances within the while loop.
clear rotation_* distance* t2 intensity* img* time
resetRotation(mymotor_A)
resetRotation(mymotor_D)

mymotor_A.Speed = 50
mymotor_D.Speed = 50

distance = readDistance(mysonicsensor);
rotation_A(1) = readRotation(mymotor_A);
rotation_D(1) = readRotation(mymotor_D);

i = 1;
tic

while distance > 0.30
    i = i + 1;
    distance(i) = readDistance(mysonicsensor);
    rotation_A(i) = readRotation(mymotor_A);
    rotation_D(i) = readRotation(mymotor_D);
    time(i) = toc;
    start(mymotor_A)
    start(mymotor_D)
end
stop(mymotor_A)
stop(mymotor_D)

time_forward = time(i);

mymotor_A.Speed = -50
mymotor_D.Speed = -50

while time(i) < time_forward+2
    i = i + 1;
    start(mymotor_A)
    start(mymotor_D)
    distance(i) = readDistance(mysonicsensor);
    rotation_A(i) = readRotation(mymotor_A);
    rotation_D(i) = readRotation(mymotor_D);
    time(i) = toc;
    start(mymotor_A)
    start(mymotor_D)
end
stop(mymotor_A)
stop(mymotor_D)

%%
% Plotting the results
figure1 = figure('Position',[200 600 800 400],...
    'Color',[1 1 1]);
axes1 = axes('LineWidth',1,...
    'FontName','Helvetica',...
    'FontSize',12,...
    'XGrid','on',...
    'YGrid','on');
yyaxis left
line1 = line(time,distance,...
    'LineWidth',1);
xlabel1 = xlabel('Time (s)',...
    'FontName','Helvetica',...
    'FontSize',12);
ylabel1 = ylabel('Distance (m)',...
    'FontName','Helvetica',...
    'FontSize',12);
yyaxis right
line2 = line(time,rotation_A,...
    'LineWidth',1);
ylabel2 = ylabel('Motor Rotation Value (degrees)',...
    'FontName','Helvetica',...
    'FontSize',12);







