%% Exercise "Communicating with the EV3 brick MATLAB"
%
% by Martin H. Trauth, 6 March 2017
% http://mres.uni-potsdam.de

%%
% First clear the workspace, the command window and close all figures
clear, clc, close all

%%
% Connecting the EV3 brick with the PC. You have to change the IP address
% and serial number of the EV3 brick (WiFi), and the name of the brick and
% the Bluetooth serial port (Bluetooth).
%
% USB Connection: The USB should work without any problems. Simply connect
% the EV3 brick with your PC using the LEGO MINDSTORMS USB cable.
%
% WiFi Connection: We used a WiFi router, in our example an Apple AirPort
% Time Capsule, not connected to the internet. The router used the IP
% address 10.0.1.1, the PC used 10.0.1.2 and the EV3 brick used 10.0.1.3.
% The serial number of the EV3 brick was 00165350bf24. After we established
% the WiFi connection according to the LEGO MINDSTORMS manual we noticed
% that there was no communication between the PC and the brick although the
% EV3 brick had the correct IP address according to Brick Info. In our case
% disconnecting and reconnecting helped. Eventually you should check the
% data flow between the brick and the PC with "system('ping 10.0.1.3')". If
% there is no communication between the brick and the PC then disconnect/
% reconnect.
%
% Bluetooth connection: After having connected the brick with the PC using
% Bluetooth according to the LEGO MINDSTORMS manual use we have to find out
% the Bluetooth serial port of the EV3 brick using "system('ls /dev/tty*')"
% where EV3_1 was the name of our EV3 brick.
mynumber = input('Enter a number: USB=1, WiFi=2, Bluetooth=3. My Number=');
switch mynumber
    case 1
        mylego = legoev3('USB')
    case 2
        mylego = legoev3('Wifi','10.0.1.3','00165350bf24')
    case 3
        mylego = legoev3('Bluetooth','/dev/tty.EV3_1-SerialPort')
    otherwise
        disp('Invalid number!')
end

%%
% Writing text on the EV3 brick LCD display, after 3 seconds clear text.
writeLCD(mylego,'Hello World!')
pause(10)
clearLCD(mylego)

%%
% Play 800 Hz tone for 0.5 seconds and at a volume level 2 on the speaker
% of the EV3 brick
playTone(mylego,800,0.5,2)

%%
% Changing the color of the EV3 brick from green to orange for three
% seconds, then back to green.
writeStatusLight(mylego,'orange','solid')
pause(3)
writeStatusLight(mylego,'green','solid')

