function varargout = trauthagemodeling(varargin)
% TRAUTHAGEMODELING MATLAB code for trauthagemodeling.fig
%      TRAUTHAGEMODELING, by itself, creates a new TRAUTHAGEMODELING or raises the existing
%      singleton*.
%
%      H = TRAUTHAGEMODELING returns the handle to a new TRAUTHAGEMODELING or the handle to
%      the existing singleton*.
%
%      TRAUTHAGEMODELING('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in TRAUTHAGEMODELING.M with the given input arguments.
%
%      TRAUTHAGEMODELING('Property','Value',...) creates a new TRAUTHAGEMODELING or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before trauthagemodeling_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to trauthagemodeling_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help trauthagemodeling

% Last Modified by GUIDE v2.5 04-Feb-2016 14:51:52

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @trauthagemodeling_OpeningFcn, ...
                   'gui_OutputFcn',  @trauthagemodeling_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before trauthagemodeling is made visible.
function trauthagemodeling_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to trauthagemodeling (see VARARGIN)

% Choose default command line output for trauthagemodeling
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes trauthagemodeling wait for user response (see UIRESUME)
% uiwait(handles.figure1);

global maxage slices shapeinit data ages colors hiatuses screen

% Get screensize
screen = get(0,'screensize');

% Load data
data = load('input_section.txt');
data(end+1,:) = [data(end,2) data(end,2) data(end,3)];
ages = load('input_ages.txt');

% Default values
maxage = 401;
slices = 0.1;
shapeinit = [2 0.5; 2 0.8; 2 2];
hiatuses = zeros(6,2);

% Colors
colors = [
         0    0.4471    0.7412
    0.8510    0.3255    0.0980
    0.9294    0.6941    0.1255
    0.4941    0.1843    0.5569
    0.4667    0.6745    0.1882
    0.3020    0.7451    0.9333
    0.6353    0.0784    0.1843
];


% --- Outputs from this function are returned to the command line.
function varargout = trauthagemodeling_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

function edit1_Callback(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double
global shapeinit
shapeinit(1,1) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), ...
        get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit2_Callback(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit2 as text
%        str2double(get(hObject,'String')) returns contents of edit2 as a double
global shapeinit
shapeinit(1,2) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), ...
        get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double
global shapeinit
shapeinit(2,1) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), ...
        get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit4_Callback(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit4 as text
%        str2double(get(hObject,'String')) returns contents of edit4 as a double
global shapeinit
shapeinit(2,2) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), ...
        get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit5_Callback(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit5 as text
%        str2double(get(hObject,'String')) returns contents of edit5 as a double
global shapeinit
shapeinit(3,1) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), ...
        get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit6_Callback(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit6 as text
%        str2double(get(hObject,'String')) returns contents of edit6 as a double
global shapeinit
shapeinit(3,2) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), ...
        get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit7_Callback(hObject, eventdata, handles)
% hObject    handle to edit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit7 as text
%        str2double(get(hObject,'String')) returns contents of edit7 as a double
global maxage
maxage = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit7_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), ...
        get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit8_Callback(hObject, eventdata, handles)
% hObject    handle to edit8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit8 as text
%        str2double(get(hObject,'String')) returns contents of edit8 as a double
global slices
slices = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit8_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), ...
        get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit17_Callback(hObject, eventdata, handles)
% hObject    handle to edit17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit17 as text
%        str2double(get(hObject,'String')) returns contents of edit17 as a double
global hiatuses
hiatuses(1,1) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit17_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit18_Callback(hObject, eventdata, handles)
% hObject    handle to edit18 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit18 as text
%        str2double(get(hObject,'String')) returns contents of edit18 as a double
global hiatuses
hiatuses(2,1) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit18_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit18 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit19_Callback(hObject, eventdata, handles)
% hObject    handle to edit19 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit19 as text
%        str2double(get(hObject,'String')) returns contents of edit19 as a double
global hiatuses
hiatuses(3,1) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit19_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit19 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit20_Callback(hObject, eventdata, handles)
% hObject    handle to edit20 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit20 as text
%        str2double(get(hObject,'String')) returns contents of edit20 as a double
global hiatuses
hiatuses(4,1) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit20_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit20 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit21_Callback(hObject, eventdata, handles)
% hObject    handle to edit21 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit21 as text
%        str2double(get(hObject,'String')) returns contents of edit21 as a double
global hiatuses
hiatuses(5,1) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit21_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit21 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit22_Callback(hObject, eventdata, handles)
% hObject    handle to edit22 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit22 as text
%        str2double(get(hObject,'String')) returns contents of edit22 as a double
global hiatuses
hiatuses(6,1) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit22_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit22 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit23_Callback(hObject, eventdata, handles)
% hObject    handle to edit23 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit23 as text
%        str2double(get(hObject,'String')) returns contents of edit23 as a double
global hiatuses
hiatuses(1,2) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit23_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit23 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit24_Callback(hObject, eventdata, handles)
% hObject    handle to edit24 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit24 as text
%        str2double(get(hObject,'String')) returns contents of edit24 as a double
global hiatuses
hiatuses(2,2) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit24_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit24 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit25_Callback(hObject, eventdata, handles)
% hObject    handle to edit25 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit25 as text
%        str2double(get(hObject,'String')) returns contents of edit25 as a double
global hiatuses
hiatuses(3,2) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit25_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit25 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit26_Callback(hObject, eventdata, handles)
% hObject    handle to edit26 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit26 as text
%        str2double(get(hObject,'String')) returns contents of edit26 as a double
global hiatuses
hiatuses(4,2) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit26_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit26 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit27_Callback(hObject, eventdata, handles)
% hObject    handle to edit27 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit27 as text
%        str2double(get(hObject,'String')) returns contents of edit27 as a double
global hiatuses
hiatuses(5,2) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit27_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit27 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit28_Callback(hObject, eventdata, handles)
% hObject    handle to edit28 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit28 as text
%        str2double(get(hObject,'String')) returns contents of edit28 as a double
global hiatuses
hiatuses(6,2) = str2double(get(hObject,'String'));

% --- Executes during object creation, after setting all properties.
function edit28_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit28 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
display_agemodel(hObject, eventdata, handles)

function display_agemodel(hObject, eventdata, handles)
global slices shapeinit data ages maxage colors hiatuses

[depth,stype] = stairs(data(:,1),data(:,3),'o');

for i = 1 : length(depth)
    if i>=length(depth)-1, break, end
    if     stype(i) < stype(i+1)
           depth(i)   = depth(i)   -0.001;    
    elseif stype(i) > stype(i+1)
           depth(i+1) = depth(i+1) +0.001;             
    elseif stype(i) == stype(i+1) && ...
           stype(i+1) == stype(i+2)
           depth(i+1) = [];
           stype(i+1) = [];
    end
end

edepth = min(depth):slices:max(depth);
edepth = edepth';
estype = interp1(depth,stype,edepth,'linear');
edepth(1,:) = [];
estype(1,:) = [];

xa = -10 : 0.01 : 20; xa = xa';
xa = slices .* xa;
shape(:,1) = shapeinit(:,1);
shape(:,2) = slices .* shapeinit(:,2);
for i = 1:length(shape)
    xt(:,i) = xa;
    yt(:,i) = gampdf(xt(:,i), shape(i,1), shape(i,2));
    yt(:,i) = yt(:,i) ./ sum(yt(:,i));
    md(i,1) = (shape(i,1)-1)*shape(i,2);
end
plot(handles.AxesGammaDistributions,xt,yt,'LineWidth',1)
title(handles.AxesGammaDistributions,'Typical Unit Deposition Times')
xlabel(handles.AxesGammaDistributions,'Unit Deposition Time (kyr/m)')
ylabel(handles.AxesGammaDistributions,'Frequency')
set(handles.AxesGammaDistributions,'XGrid','On','YGrid','On')
ltext = ({'Sediment Type 1','Sediment Type 2','Sediment Type 2'});
legend(handles.AxesGammaDistributions,'Entries',ltext,'Box','Off')

etimeaccsed = zeros(length(edepth),1);
etimedissed = zeros(length(edepth),length(xa));
for i = 1 : length(edepth)
    etimeaccsed(i,1) = slices .* md(uint8(estype(i)));
    etimedissed(i,:) = yt(:,uint8(estype(i)));
end

for i = 1 : size(etimedissed,1)
    etimedissedmodes(i,1) = xa(etimedissed(i,:) == max(etimedissed(i,:)));
    xs = xa; xs = xs';    
    cs = cumsum(etimedissed(i,:)); cs = cs';
    xs(cs==0) = [];
    cs(cs==0) = [];
    xs(cs==max(cs)) = [];
    cs(cs==max(cs)) = [];  
    q1(i,:) = interp1(cs,xs,0.25);
    q2(i,:) = interp1(cs,xs,0.5);
    q3(i,:) = interp1(cs,xs,0.75);
end

cummodes = cumsum(etimedissedmodes);

clear ageint
ageint(:,1) = ages(:,1);
ageint(1:end-1,2) = abs(diff(ages(:,2)));
ageint(1:end-1,3) = sqrt(ages(1:end-1,3).^2 + circshift(ages(1:end-1,3),-1).^2);

depthint = abs(ages(:,1) - circshift(ages(:,1),-1));
depthint = depthint(1:end-1);
depthslc = depthint / slices;
ageint(1:end-1,2) = ageint(1:end-1,2)./depthslc;
ageint(1:end-1,3) = ageint(1:end-1,3)./(sqrt(2)*depthslc);

[adepth1,aageint] = stairs(ageint(:,1),ageint(:,2));
[adepth2,aageerr] = stairs(ageint(:,1),ageint(:,3));
adepth1(end) = [];
adepth2(end) = [];
aageint(end) = [];
aageerr(end) = [];

for i = 1 : length(adepth1)
    if i>=length(adepth1)-1, break, end
    if     aageint(i) < aageint(i+1)
           adepth1(i)   = adepth1(i)   -0.001;  
    elseif aageint(i) > aageint(i+1)
           adepth1(i+1) = adepth1(i+1) +0.001; 
    elseif aageint(i) == aageint(i+1) && aageint(i+1) == aageint(i+2)
           adepth1(i+1) = [];
           aageint(i+1) = [];
    end
end
for i = 1 : length(adepth2)
    if i>=length(adepth2)-1, break, end
    if     aageerr(i) < aageerr(i+1)
           adepth2(i)   = adepth2(i)   -0.001;  
    elseif aageerr(i) > aageerr(i+1)
           adepth2(i+1) = adepth2(i+1) +0.001; 
    elseif aageerr(i) == aageerr(i+1) && aageerr(i+1) == aageerr(i+2)
           adepth2(i+1) = [];
           aageerr(i+1) = [];
    end
end

eageint = interp1(adepth1,aageint,edepth,'linear','extrap');
eageerr = interp1(adepth2,aageerr,edepth,'linear','extrap');

etimeaccage = zeros(length(edepth),1);
etimedisage = zeros(length(edepth),length(xa));
for i = 1 : length(edepth)
       etimeaccage(i,:) = eageint(i,:);
       etimedisage(i,:) = normpdf(xa,eageint(i,1),eageerr(i,1));
       etimedisage(i,:) = etimedisage(i,:) ./ nansum(etimedisage(i,:),2);
end

for i = 1 : size(etimedisage,1)
    etimedissedmodes(i,1) = xa(find(etimedisage(i,:) == max(etimedisage(i,:))));
    xs = xa; xs = xs';    
    cs = cumsum(etimedisage(i,:)); cs = cs';
    xs(cs==0) = [];
    cs(cs==0) = [];
    xs(cs==max(cs)) = [];
    cs(cs==max(cs)) = [];  
    q1(i,:) = interp1(cs,xs,0.25);
    q2(i,:) = interp1(cs,xs,0.5);
    q3(i,:) = interp1(cs,xs,0.75);
end

q1(q1<0) = 0;
q2(q2<0) = 0;
q3(q3<0) = 0;

cummodes = cumsum(etimedissedmodes);

xd = xa; xd = xd';
etimeoverlap = zeros(size(etimedissed));
for i = 1 : length(edepth)
    etimeoverlap(i,etimedisage(i,:)<etimedissed(i,:)) = ...
        etimedisage(i,etimedisage(i,:)<etimedissed(i,:));
    etimeoverlap(i,etimedissed(i,:)<=etimedisage(i,:)) = ...
        etimedissed(i,etimedissed(i,:)<=etimedisage(i,:));
    etimeoverlappercent(i) = max(cumsum(etimeoverlap(i,:)));
end

etimedissall = etimedisage .* etimedissed;
for i = 1 : length(edepth)
    etimedissall(i,:) = etimedissall(i,:) ./ sum(etimedissall(i,:));
end

for i = 1 : size(etimedissall,1)
    etimedissallmodes(i,1) = xa(etimedissall(i,:) == max(etimedissall(i,:)));
    xs = xa; xs = xs';    
    cs = cumsum(etimedissall(i,:)); cs = cs';
    xs(cs==0) = [];
    cs(cs==0) = [];
    xs(cs==max(cs)) = [];
    cs(cs==max(cs)) = [];  
    q1(i,:) = interp1(cs,xs,0.25);
    q2(i,:) = interp1(cs,xs,0.5);
    q3(i,:) = interp1(cs,xs,0.75);
end

cummodes = cumsum(etimedissallmodes);

[axes1,line1,line2] = plotyy(handles.AxesPercentOverlap,edepth,maxage-cummodes, ...
                        edepth,100*etimeoverlappercent); hold on
line3 = plot(handles.AxesPercentOverlap,edepth,maxage-cummodes, ...
                        edepth,maxage-cummodes+q1/slices, ...
                        edepth,maxage-cummodes-q3/slices,'LineWidth',1);
line4 = errorbar(handles.AxesPercentOverlap,ages(:,1),ages(:,2),ages(:,3),'k');
set(get(axes1(1),'Title'),...
  'String','Total Accumulation Time/% Overlap')
set(get(axes1(1),'XLabel'),...
  'String','Depth in Core [m]')
set(get(axes1(1),'YLabel'),...
  'String','Total Accumulated Time [kyr]')
set(get(axes1(2),'YLabel'),...
  'String','Percent Overlap [%]')
set(axes1(1),'YColor',colors(1,:))
set(line3(1),'Color',colors(1,:))
set(line3(2:3),'Color',colors(5,:))
set(line4,'Color',[0 0 0],'LineStyle','none')
grid
hold off

cummodes_h = cummodes;

% This is where the hiatuses are applied to the age model. As an example
% use a single hiatus at 35 m of 2 kyrs.
for i = 1:length(hiatuses)
    cummodes_h(edepth>hiatuses(i,1))  = cummodes_h(edepth>hiatuses(i,1)) + hiatuses(i,2);
end

[axes1,line5,line6] = plotyy(handles.AxesAgeModel,edepth,maxage-cummodes_h,...
              edepth,maxage-cummodes_h); hold on
set(axes1(1),'YColor','k')
set(axes1(2),'YTickLabels',[],'YColor','k')
grid on
line7 = plot(handles.AxesAgeModel,edepth,maxage-cummodes_h+q1/slices);
line8 = plot(handles.AxesAgeModel,edepth,maxage-cummodes_h-q3/slices);
set(line5,'Color',colors(1,:))
set(line6,'Color',colors(1,:))
set(line7,'Color',colors(5,:))
set(line8,'Color',colors(5,:))
line9 = errorbar(handles.AxesAgeModel,ages(:,1),ages(:,2),ages(:,3),'+k');
set(line9,'LineWidth',1)
title(handles.AxesAgeModel,'Age Model')
xlabel(handles.AxesAgeModel,'Depth in Core (m)')
ylabel(handles.AxesAgeModel,'Total Accumulation Time (kyr)')
ltext = ({'Median','1st Quartile','2nd Quartile'});
legend(handles.AxesAgeModel,'Entries',ltext,'Box','Off')
hold off

agemodel(:,1) = edepth;
agemodel(:,2) = -maxage+cummodes_h;

% Export results to workspace
assignin('base','agemodel' ,agemodel)

% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global screen
helpstring1 ='Here you can define';
helpstring2 ='up to six hiatuses';
helpstring3 ='by their location';
helpstring4 ='and duration.';
figure('Position',[screen(1,3)/2 screen(1,4)/2 250 150],...
       'Color','w','MenuBar','none','Name','Help','NumberTitle','off')
text(0.1,0.8,helpstring1,'HorizontalAlignment','left','FontSize',18)
text(0.1,0.6,helpstring2,'HorizontalAlignment','left','FontSize',18)
text(0.1,0.4,helpstring3,'HorizontalAlignment','left','FontSize',18)
text(0.1,0.2,helpstring4,'HorizontalAlignment','left','FontSize',18)
axis off

% --- Executes on button press in pushbutton3.
function pushbutton3_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global screen
helpstring1 ='Here you can define';
helpstring2 ='the parameters shape';
helpstring3 ='and scale of the';
helpstring4 ='Gamma distribution.';
figure('Position',[screen(1,3)/2 screen(1,4)/2 250 150],...
       'Color','w','MenuBar','none','Name','Help','NumberTitle','off')
text(0.1,0.8,helpstring1,'HorizontalAlignment','left','FontSize',18)
text(0.1,0.6,helpstring2,'HorizontalAlignment','left','FontSize',18)
text(0.1,0.4,helpstring3,'HorizontalAlignment','left','FontSize',18)
text(0.1,0.2,helpstring4,'HorizontalAlignment','left','FontSize',18)
axis off

% --- Executes on button press in pushbutton4.
function pushbutton4_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global screen
helpstring1 ='Here you can define';
helpstring2 ='the maximum age of';
helpstring3 ='the section base and';
helpstring4 ='slice thickness.';
figure('Position',[screen(1,3)/2 screen(1,4)/2 250 150],...
       'Color','w','MenuBar','none','Name','Help','NumberTitle','off')
text(0.1,0.8,helpstring1,'HorizontalAlignment','left','FontSize',18)
text(0.1,0.6,helpstring2,'HorizontalAlignment','left','FontSize',18)
text(0.1,0.4,helpstring3,'HorizontalAlignment','left','FontSize',18)
text(0.1,0.2,helpstring4,'HorizontalAlignment','left','FontSize',18)
axis off
